import palanthir
from utilities import isInRect

def onLoad():
	palanthir.registerpackethandler( 0x7C, onPacket )
	return 0

def onPacket( Packet ):
	QuestionLength = Packet.getbyte( 9 )
	Question = Packet.getasciistring( 10, QuestionLength )
	
	P = 10 + QuestionLength
	Count = Packet.getbyte( P )
	P += 1
	
	ModelIDs = []
	ModelHues = []
	Answers = []
	
	for i in range( 0, Count ):
		ModelIDs += [Packet.getword( P )]
		P += 2
		ModelHues += [Packet.getword( P )]
		P += 2
		AnswerLength = Packet.getbyte( P )
		Answers += [Packet.getasciistring( P+1, AnswerLength )]
		P += 1 + AnswerLength
	
	if Count == 0 or ModelIDs[ 0 ] == 0:
		Gump = palanthir.newgump( 100, 100 )
		Gump.nomove = 1
		Gump.cv[ "serial" ] = Packet.getlongword( 3 )
		Gump.cv[ "menuid" ] = Packet.getword( 7 )
		Gump.onbuttonclick = onButtonClickGray
		
		BackGround = Gump.addresizegump( 0, 0, 400, 100, 0x13EC, 0, 1 )
		Gump.addtext( 20, 20, Question, 0, 0x481, 1 )
		
		PY = 50
		for i in range( 0, Count ):
			Gump.addradiobutton( 20, PY+3, 0x146F, 0x146E, 0, i+1, 1, 1 )
			Answer = Gump.addcroppedtext( 50, PY, 330, 500, Answers[ i ], 0, 0x481, 1, 10 )
			PY += Answer.textureheight + 5
		
		Gump.addbutton( 45, PY + 20, 0x1450, 0x1451, 0, 1 )
		Gump.addbutton( 165, PY + 20, 0x13B2, 0x13B3, 2, 1 )
		
		BackGround.height = PY + 60
		
		Gump.addresizegump( 20, 20, 300, 200, 0xA28, 0, 2 )
		Gump.addtext( 60, 50, "You have to choose one to continue.", 0, 0x481, 2 )
		Gump.addbutton( 160, 170, 0x47E, 0x480, 3, 2, 0x480 )
		Gump.show()
	else:
		Gump = palanthir.newgump( 100, 100 )
		Gump.cv[ "serial" ] = Packet.getlongword( 3 )
		Gump.cv[ "menuid" ] = Packet.getword( 7 )
		Gump.ondblclickxy = onDblClickXY
		Gump.onclickxy = onClickXY
		Gump.ondrawgump = onDraw
		
		if palanthir.isme():
			Gump.addhuebutton( 1, 1, 292, 131, 255, 255, 255, 100, 0 )
		Gump.addimage( 0, 0, 0x910, 0, 0 )
		
		if palanthir.isme():
			Gump.cv[ "description" ] = Gump.addcroppedtext( 36, 94, 200, 20, "", 0, 0x481, 0 )
			Gump.addcroppedtext( 34, 17, 200, 20, Question, 0, 0x481, 0 )
		else:
			Gump.cv[ "description" ] = Gump.addcroppedtext( 40, 100, 200, 20, "", 0, 1, 0, -1, 0 )
			Gump.addcroppedtext( 38, 14, 200, 20, Question, 0, 1, 0, -1, 0 )
		
		Gump.cv[ "ModelIDs" ] = ModelIDs
		Gump.cv[ "ModelHues" ] = ModelHues
		Gump.cv[ "Answers" ] = Answers
		Gump.cv[ "Buttons" ] = []
		Gump.cv[ "StartNumber" ] = 0
		Gump.cv[ "Count" ] = Count
		
		for ModelID in ModelIDs:
			Gump.cv[ "Buttons" ] += [Gump.addtilepic( 0, 45, ModelID, 0, 2 )]
		
		StartNumberChanged( Gump )
		
		Gump.show()
	return 1

def onButtonClickGray( Gump, ReturnNumber ):
	if ReturnNumber == 1:
		Packet = palanthir.newpacket( 0x7D, 13 )
		Packet.setlongword( 1, Gump.cv[ "serial" ] )
		Packet.setword( 5, Gump.cv[ "menuid" ] )
		Packet.setword( 7, 0 )
		Packet.setword( 9, 0 )
		Packet.setword( 11, 0 )
		Packet.send()
		Gump.delete()
		return 1
	elif ReturnNumber == 2:
		if not Gump.getradiobutton( 1 ):
			Gump.activepage = 2
		else:
			Packet = palanthir.newpacket( 0x7D, 13 )
			Packet.setlongword( 1, Gump.cv[ "serial" ] )
			Packet.setword( 5, Gump.cv[ "menuid" ] )
			Packet.setword( 7, Gump.getradiobutton( 1 ) )
			Packet.setword( 9, 0 )
			Packet.setword( 11, 0 )
			Packet.send()
			Gump.delete()
		return 1
	elif ReturnNumber == 3:
		Gump.activepage = 1
		return 1
	return 0

def StartNumberChanged( Gump ):
	Buttons = Gump.cv[ "Buttons" ]
	
	for Button in Buttons:
		Button.page = 2
	
	PX = 42
	for i in range( Gump.cv[ "StartNumber" ], min( Gump.cv[ "Count" ], Gump.cv[ "StartNumber" ]+6 ) ):
		Button = Buttons[ i ]
		Button.page = 0
		Button.x = PX
		Button.width = max( palanthir.data.getstaticartheight( Button.id ), 255-PX )
		PX += palanthir.data.getstaticartheight( Button.id )
		if PX >= 255:
			break
	
	return 0

def onClickXY( Gump, X, Y ):
	if palanthir.isme():
		if isInRect( X, Y, 6, 50, 13, 90 ):
			if Gump.cv[ "StartNumber" ] > 0:
				Gump.cv[ "StartNumber" ] -= 1
				StartNumberChanged( Gump )
		elif isInRect( X, Y, 280, 50, 287, 90 ):
			if Gump.cv[ "StartNumber" ] < Gump.cv[ "Count" ]-1:
				Gump.cv[ "StartNumber" ] += 1
				StartNumberChanged( Gump )
	else:
		if isInRect( X, Y, 30, 50, 40, 90 ):
			if Gump.cv[ "StartNumber" ] > 0:
				Gump.cv[ "StartNumber" ] -= 1
				StartNumberChanged( Gump )
		elif isInRect( X, Y, 255, 50, 265, 90 ):
			if Gump.cv[ "StartNumber" ] < Gump.cv[ "Count" ]-1:
				Gump.cv[ "StartNumber" ] += 1
				StartNumberChanged( Gump )		
	return 0

def onDblClickXY( Gump, X, Y ):
	if isInRect( X, Y, 42, 50, 252, 90 ):
		PX = X-42
		Index = Gump.cv[ "StartNumber" ]
		while (PX > 0) and (Index < Gump.cv[ "Count" ]-1):
			PX -= palanthir.data.getstaticartheight( Gump.cv[ "Buttons" ][ Index ].id )
			if PX > 0:
				Index += 1
				
		Packet = palanthir.newpacket( 0x7D, 13 )
		Packet.setlongword( 1, Gump.cv[ "serial" ] )
		Packet.setword( 5, Gump.cv[ "menuid" ] )
		Packet.setword( 7, Index+1 )
		Packet.setword( 9, Gump.cv[ "ModelIDs" ][ Index ] )
		Packet.setword( 11, Gump.cv[ "ModelHues" ][ Index ] )
		Packet.send()
		Gump.delete()
		return 1
	return 0

def onDraw( Gump ):
	if isInRect( palanthir.mouse().x - Gump.x, palanthir.mouse().y - Gump.y, 42, 50, 252, 90 ):
		PX = palanthir.mouse().x - Gump.x - 42
		Index = Gump.cv[ "StartNumber" ]
		while (PX > 0) and (Index < Gump.cv[ "Count" ]-1):
			PX -= palanthir.data.getstaticartheight( Gump.cv[ "Buttons" ][ Index ].id )
			if PX > 0:
				Index += 1
		Gump.cv[ "description" ].text = Gump.cv[ "Answers" ][ Index ]
	return 0