import palanthir

BACKGROUND = 0x2B02
EDGEBACK_GUMP = 0x8BB
EDGEFORWARD_GUMP = 0x8BC
DIVISORID = 0x835
Unarmed = 0

ArmorIgnore = { "Name" : "Armor Ignore",
		"Id" : 1,
		"GumpId" : 0x5200,
		"Primary" : [ 0xF43, 0xF44, 0x13AF, 0x13B0, 0x143C, 0x143D, 0x26CC, 0x26C2, 0x26BD, 0x26C7, 0xF63, 0xF62, 0x1400, 0x1401, 0x13B7, 0x13B8, 0xF60, 0xF61 ],
		"Secondary" : [ 0xF5E, 0xF5F, 0x13FE, 0x13FF ] }

BleedAttack = { "Name" : "Bleed Attack",
		"Id" : 2,
		"GumpId" : 0x5201,
		"Primary" : [ 0xF47, 0xF48, 0xF45, 0xF46, 0xEC2, 0xEC3, 0x26BA, 0x26C4, 0xE87, 0xE88, 0x1404, 0x1405, 0x1440, 0x1441 ],
		"Secondary" : [ 0x13FA, 0x13FB, 0x13AF, 0x13B0, 0x1406, 0x1407 ] }

ConcussionBlow = { "Name" : "Concussion Blow",
		   "Id" : 3,
		   "GumpId" : 0x5202,
		   "Primary" : [ 0xF5C, 0xF5D, 0xF4F, 0xF50, 0x13F9, 0x13F8 ],
		   "Secondary" : [ 0xF47, 0xF48, 0x143A, 0x143B, 0x143E, 0x143F, 0xE8A, 0xE89, 0x26C0, 0x26CA, 0x13B7, 0x13B8, 0xF60, 0xF61 ] }

CrushingBlow = { "Name" : "Crushing Blow",
		 "Id" : 4,
		 "GumpId" : 0x5203,
		 "Primary" : [ 0xF49, 0xF4A, 0x143A, 0x143B, 0x26BC, 0x26C6, 0x1406, 0x1407, 0x13F4, 0x13F5, 0xF5E, 0xF5F, 0x13B9, 0x13BA ],
		 "Secondary" : [ 0x1438, 0x1439 ] }

Disarm = { "Name" : "Disarm",
	   "Id" : 5,
	   "GumpId" : 0x5204,
	   "Primary" : [Unarmed],
	   "Secondary" : [ 0xF43, 0xF44, 0xE85, 0xE86, 0x13F6, 0x13F7, 0xEC4, 0xEC5, 0xF5C, 0xF5D, 0x1404, 0x1405, 0x13F4, 0x13F5 ] }

Dismount = { "Name" : "Dismount",
	     "Id" : 6,
	     "GumpId" : 0x5205,
	     "Primary" : [ 0x26C0, 0x26CA ],
	     "Secondary" : [ 0xF49, 0xF4A, 0x13B3, 0x13B4, 0xF4D, 0xF4E, 0x13FC, 0x13FD, 0x26BD, 0x26C7, 0xE87, 0xE88 ] }

DoubleStrike = { "Name" : "Double Strike",
		 "Id" : 7,
		 "GumpId" : 0x5206,
		 "Primary" : [ 0xF4C, 0xF4B, 0x13FF, 0x13FE, 0xE85, 0xE86, 0x1442, 0x1443, 0x26C3, 0x26CD, 0x26BF, 0x26C9, 0xE89, 0xE8A, 0x26C1, 0x26CB, 0x13B6, 0x13B5 ],
		 "Secondary" : [] }

Infecting = { "Name" : "Infecting",
	      "Id" : 8,
	      "GumpId" : 0x5207,
	      "Primary" : [ 0xF51, 0xF52, 0x13F6, 0x13F7 ],
	      "Secondary" : [ 0xEC2, 0xEC3, 0x26BF, 0x26C9, 0x26C8, 0x26BE, 0x1400, 0x1401 ] }

MortalStrike = { "Name" : "Mortal Strike",
		 "Id" : 9,
		 "GumpId" : 0x5208,
		 "Primary" : [],
		 "Secondary" : [ 0x26C1, 0x26CB, 0xF46, 0xF45, 0x143C, 0x143D, 0x26BC, 0x26C6, 0x13B1, 0x13B2, 0xF4F, 0xF50, 0x1402, 0x1403, 0x26BB, 0x26C5 ] }

MovingShot = { "Name" : "Moving Shot",
	       "Id" : 10,
	       "GumpId" : 0x5209,
	       "Primary" : [ 0x13FC, 0x13FD ],
	       "Secondary" : [ 0x26C2, 0x26CC, 0x26C3, 0x26CD ] }

ParalyzeBlow = { "Name" : "Paralyze Blow",
		 "Id" : 11,
		 "GumpId" : 0x520A,
		 "Primary" : [ 0xF4D, 0xF4E, 0x13B1, 0x13B2, 0x26C8, 0x26BE, 0x26BB, 0x26C5 ],
		 "Secondary" : [ Unarmed, 0x26BA, 0x26C4, 0xF62, 0xF63, 0xDF0, 0xDF1, 0x13F9, 0x13F8, 0x13B5, 0x13B6, 0x13BA, 0x13B9 ] }

ShadowStrike = { "Name" : "Shadow Strike",
		 "Id" : 12,
		 "GumpId" : 0x520B,
		 "Primary" : [ 0xEC4, 0xEC5, 0x13B3, 0x13B4, 0x1402, 0x1403],
		 "Secondary" : [ 0x1442, 0x1443, 0xF51, 0xF52, 0x1440, 0x1441 ] }

WhirlwindAttack = { "Name" : "Whirlwind Attack",
		    "Id" : 13,
		    "GumpId" : 0x520C,
		    "Primary" : [ 0x13FA, 0x13FB, 0x1438, 0x1439, 0x143F, 0x143E, 0xDF0, 0xDF1 ],
		    "Secondary" : [ 0xF4C, 0xF4B] }

SpecialAbilities = [ ArmorIgnore,
	      BleedAttack,
	      ConcussionBlow,
	      CrushingBlow,
	      Disarm,
	      Dismount,
	      DoubleStrike,
	      Infecting,
	      MortalStrike,
	      MovingShot,
	      ParalyzeBlow,
	      ShadowStrike,
	      WhirlwindAttack ]

MainSites = ( len( SpecialAbilities ) + 12 ) / 13

def GetAbility( Id ):
	for Ability in SpecialAbilities:
		if Ability[ "Id" ] == Id:
			return Ability
	return { "Name" : "Unknown", "Id" : 0, "GumpId" : 0, "Primary" : [], "Secondary" : [] }

class	_Weapon:
	def __init__( self ):
		self.primary = -1
		self.secondary = -1
		self.broken = 0

Weapons = {}

for i in range( 0, len( SpecialAbilities ) ):	
	Ability = SpecialAbilities[ i ]
	Ability[ "InternalId" ] = i
	WeaponNames = {}
	for WeaponId in Ability[ "Primary" ]:
		if Weapons.has_key( str( WeaponId ) ):
			Weapon = Weapons[ str( WeaponId ) ]
			if Weapon.primary != -1:
				palanthir.log( 'Weapon 0x%x has double primary ability (%s,%s)' % (WeaponId,GetAbility( Weapon.primary )[ "Name" ],Ability[ "Name" ]) )
				Weapon.broken = 1
			else:
				Weapon.primary = Ability[ "Id" ]
		else:
			Weapon = _Weapon()
			Weapon.primary = Ability[ "Id" ]
			Weapons[ str( WeaponId ) ] = Weapon
		WeaponNames[ palanthir.data.getstatictileentry( WeaponId )[ "name" ] ] = 1
	
	for WeaponId in Ability[ "Secondary" ]:
		if Weapons.has_key( str( WeaponId ) ):
			Weapon = Weapons[ str( WeaponId ) ]
			if Weapon.secondary != -1:
				palanthir.log( 'Weapon 0x%x has double secondary ability (%s,%s)' % (WeaponId,GetAbility( Weapon.primary )[ "Name" ],Ability[ "Name" ]) )
				Weapon.broken = 1
			else:
				Weapon.secondary = Ability[ "Id" ]
		else:
			Weapon = _Weapon()
			Weapon.secondary = Ability[ "Id" ]
			Weapons[ str( WeaponId ) ] = Weapon
		WeaponNames[ palanthir.data.getstatictileentry( WeaponId )[ "name" ] ] = 1
	Ability[ "WeaponNames" ] = WeaponNames.keys()

for WeaponId in Weapons.keys():
	if Weapons[ WeaponId ].broken:
		del Weapons[ WeaponId ]
	elif Weapons[ WeaponId ].primary == -1:
		palanthir.log( 'Warning: Weapon 0x%x has no primary ability' % (int(WeaponId)) )
	elif Weapons[ WeaponId ].secondary == -1:
		palanthir.log( 'Warning: Weapon 0x%x has no secondary ability' % (int(WeaponId)) )

palanthir.log( "%d Weapons loaded." % (len( Weapons.keys() )) )

def GetPrimaryAbility():
	player = palanthir.world.getplayer()
	item = player.getitemonlayer( 1 )
	if item and Weapons.has_key( str( item.id ) ):
		return Weapons[ str( item.id ) ].primary
	item = player.getitemonlayer( 2 )
	if item and Weapons.has_key( str( item.id ) ):
		return Weapons[ str( item.id ) ].primary
	if Weapons.has_key( str( Unarmed ) ):
		return Weapons[ str( Unarmed ) ].primary
	return 0

def GetSecondaryAbility():
	player = palanthir.world.getplayer()
	item = player.getitemonlayer( 1 )
	if item and Weapons.has_key( str( item.id ) ):
		return Weapons[ str( item.id ) ].secondary
	item = player.getitemonlayer( 2 )
	if item and Weapons.has_key( str( item.id ) ):
		return Weapons[ str( item.id ) ].secondary
	if Weapons.has_key( str( Unarmed ) ):
		return Weapons[ str( Unarmed ) ].secondary
	return 0

def OpenSpecialAbilityGump():
	if palanthir.getcv().has_key( "specialabilitygump" ):
		return 0
	
	X = palanthir.charconfig().getinteger( "specialabilitygumpX" )
	if X == 0:
		X = 100
	Y = palanthir.charconfig().getinteger( "specialabilitygumpY" )
	if Y == 0:
		Y = 100
	
	Gump = palanthir.newgump( X, Y )
	Gump.ondelete = onDelete
	Gump.onbuttonclick = onButtonClick
	Gump.ondblclick = onDblClick
	Gump.onmovegump = onMoveGump
	Gump.activepage = 1
	
	Gump.addimage( 0, 0, BACKGROUND, 0, 0 )
	
	Gump.addtext( 100, 10, "Index", 0, 2, 1, 0 )
	Gump.addtext( 260, 10, "Index", 0, 2, 1, 0 )
	
	if Weapons.has_key( str( Unarmed ) ):
		PriW = GetAbility( Weapons[ str( Unarmed ) ].primary )[ "GumpId" ]
		SecW = GetAbility( Weapons[ str( Unarmed ) ].secondary )[ "GumpId" ]
	else:
		PriW = 0
		SecW = 0
	
	Gump.cv[ "PrimaryIcons" ] = []
	Gump.cv[ "SecondaryIcons" ] = []
	
	for Page in range( 1, MainSites + 1 ):
		Y = 40
		for i in range( (Page-1)*13, min( len( SpecialAbilities ), (Page-1)*13+9 ) ):
			Gump.addtextbutton( 60, Y, 100+i, SpecialAbilities[ i ][ "Name" ], 1, Page, 120, 0x223, 0x481, 0x481, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0 )
			Y += 15
	
		Y = 40
		for i in range( (Page-1)*13+9, min( len( SpecialAbilities ), (Page-1)*13+13 ) ):
			Gump.addtextbutton( 220, Y, 100+i, SpecialAbilities[ i ][ "Name" ], 1, Page, 120, 0x223, 0x481, 0x481, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0 )
			Y += 15
		
		Icon = Gump.addimage( 220, 105, PriW, 0, Page )
		Gump.cv[ "PrimaryIcons" ] += [Icon]		
		Icon = Gump.addimage( 220, 150, SecW, 0, Page )
		Gump.cv[ "SecondaryIcons" ] += [Icon]
		Gump.addcroppedtext( 270, 105, 80, 40, "Primary Ability Icon", 0, 2, Page, 2, 0 )
		Gump.addcroppedtext( 270, 150, 80, 40, "Secondary Ability Icon", 0, 2, Page, 2, 0 )
	
	for Ability in SpecialAbilities:
		Page = Ability[ "InternalId" ] + 100
		Gump.addimage( 55, 35, Ability[ "GumpId" ], 0, Page )
		Gump.addtiledimage( 55, 84, 133, 4, DIVISORID, 0, Page )
		Gump.addcroppedtext( 105, 35, 83, 50, Ability[ "Name" ], 1, 2, Page, 2, 0 )
		for i in range( 0, min( 6, len( Ability[ "WeaponNames" ] ) ) ):
			Name = Ability[ "WeaponNames" ][ i ].title()
			Gump.addcroppedtext( 56, 90+i*15, 130, 20, Name, 1, 0x223, Page, 1, 0 )
		for i in range( 6, min( 16, len( Ability[ "WeaponNames" ] ) ) ):
			Name = Ability[ "WeaponNames" ][ i ].title()
			Gump.addcroppedtext( 218, 30+(i-6)*15, 130, 20, Name, 1, 0x223, Page, 1, 0 )
		
	Gump.cv[ "ForwardButton" ] = Gump.addbutton( 322, 8, EDGEFORWARD_GUMP, EDGEFORWARD_GUMP, 1000, 0 )
	Gump.cv[ "BackButton" ] = Gump.addbutton( 50, 8, EDGEBACK_GUMP, EDGEBACK_GUMP, 1001, 1000 )
	Gump.show()
	
	palanthir.getcv()[ "specialabilitygump" ] = Gump
	return 0

def UpdateIconIds():
	AbilityId = GetPrimaryAbility()
	if AbilityId > 0:
		PriW = GetAbility( AbilityId )[ "GumpId" ]
	elif Weapons.has_key( str( Unarmed ) ):
		PriW = GetAbility( Weapons[ str( Unarmed ) ].primary )[ "GumpId" ]
	else:
		PriW = 0
	AbilityId = GetSecondaryAbility()
	if AbilityId > 0:
		SecW = GetAbility( AbilityId )[ "GumpId" ]
	elif Weapons.has_key( str( Unarmed ) ):
		SecW = GetAbility( Weapons[ str( Unarmed ) ].secondary )[ "GumpId" ]
	else:
		SecW = 0
	
	if palanthir.getcv().has_key( "specialabilitygump" ):
		Gump = palanthir.getcv()[ "specialabilitygump" ]
		for Icon in Gump.cv[ "PrimaryIcons" ]:
			Icon.id = PriW
		for Icon in Gump.cv[ "SecondaryIcons" ]:
			Icon.id = SecW
	
	if palanthir.getcv().has_key( "SAPrimaryIcon" ):
		palanthir.getcv()[ "SAPrimaryIcon" ].cv[ "Image" ].id = PriW

	if palanthir.getcv().has_key( "SASecondaryIcon" ):
		palanthir.getcv()[ "SASecondaryIcon" ].cv[ "Image" ].id = SecW
	return 0

def onDelete( Gump ):
	palanthir.charconfig().setinteger( "specialabilitygumpX", Gump.x )
	palanthir.charconfig().setinteger( "specialabilitygumpY", Gump.y )
	del palanthir.getcv()[ "specialabilitygump" ]
	return 0

def onButtonClick( Gump, ReturnNumber ):
	if ReturnNumber == 1000:
		Gump.cv[ "BackButton" ].page = 0
		if Gump.activepage < MainSites:
			Gump.activepage += 1			
		elif Gump.activepage == MainSites:
			Gump.activepage = 100
		elif Gump.activepage < 100 + len( SpecialAbilities ) - 1:
			Gump.activepage += 1
			if Gump.activepage == 100 + len( SpecialAbilities ) - 1:
				Gump.cv[ "ForwardButton" ].page = 1000
	elif ReturnNumber == 1001:
		Gump.cv[ "ForwardButton" ].page = 0
		if Gump.activepage > 100:
			Gump.activepage -= 1
		elif Gump.activepage == 100:
			Gump.activepage = MainSites
		elif Gump.activepage > 1:
			Gump.activepage -= 1
			if Gump.activepage == 1:
				Gump.cv[ "BackButton" ].page = 1000
	elif ReturnNumber >= 100 and ReturnNumber < 200:
		Gump.activepage = ReturnNumber
		if Gump.activepage == 100 + len( SpecialAbilities ) - 1:
			Gump.cv[ "ForwardButton" ].page = 1000
		else:
			Gump.cv[ "ForwardButton" ].page = 0
		Gump.cv[ "BackButton" ].page = 0
	return 0

def onDblClick( Gump, GumpObject ):
	if GumpObject == Gump.cv[ "ForwardButton" ]:
		Gump.activepage = 100 + len( SpecialAbilities ) - 1
		Gump.cv[ "BackButton" ].page = 0
		Gump.cv[ "ForwardButton" ].page = 1000
		return 1
	elif GumpObject == Gump.cv[ "BackButton" ]:
		Gump.activepage = 1
		Gump.cv[ "ForwardButton" ].page = 0
		Gump.cv[ "BackButton" ].page = 1000
		return 1
	return 0

def onMoveGump( Gump, GumpObject ):
	if GumpObject.isimage and GumpObject in Gump.cv[ "PrimaryIcons" ]:
		if palanthir.getcv().has_key( "SAPrimaryIcon" ):
			Icon = palanthir.getcv()[ "SAPrimaryIcon" ]
			Icon.x = palanthir.mouse().x-10
			Icon.y = palanthir.mouse().y-10
			Image = Icon.cv[ "Image" ]
			palanthir.mouse().selecteddownlgumpobject = Image
			palanthir.mouse().selectedgumpobject = Image
		else:
			Icon = palanthir.newgump( palanthir.mouse().x-10, palanthir.mouse().y-10 )
			Icon.cv[ "SAType" ] = "Primary"
			Image = Icon.addimage( 0, 0, GumpObject.id, 0, 0 )
			Icon.cv[ "Image" ] = Image
			Icon.ondelete = onIconDelete
			Icon.ondblclick = onIconDblClick
			Icon.show()
			
			palanthir.mouse().selecteddownlgumpobject = Image
			palanthir.mouse().selectedgumpobject = Image
			Icon = palanthir.getcv()[ "SAPrimaryIcon" ] = Icon
		return 1
	elif GumpObject.isimage and GumpObject in Gump.cv[ "SecondaryIcons" ]:
		if palanthir.getcv().has_key( "SASecondaryIcon" ):
			Icon = palanthir.getcv()[ "SASecondaryIcon" ]
			Icon.x = palanthir.mouse().x-10
			Icon.y = palanthir.mouse().y-10
			Image = Icon.cv[ "Image" ]
			palanthir.mouse().selecteddownlgumpobject = Image
			palanthir.mouse().selectedgumpobject = Image
		else:
			Icon = palanthir.newgump( palanthir.mouse().x-10, palanthir.mouse().y-10 )
			Icon.cv[ "SAType" ] = "Secondary"
			Image = Icon.addimage( 0, 0, GumpObject.id, 0, 0 )
			Icon.cv[ "Image" ] = Image
			Icon.ondelete = onIconDelete
			Icon.ondblclick = onIconDblClick
			Icon.show()
			
			palanthir.mouse().selecteddownlgumpobject = Image
			palanthir.mouse().selectedgumpobject = Image
			Icon = palanthir.getcv()[ "SASecondaryIcon" ] = Icon
		return 1		
	return 0

def onIconDelete( Gump ):
	if Gump.cv[ "SAType" ] == "Primary":
		del palanthir.getcv()[ "SAPrimaryIcon" ]
	elif Gump.cv[ "SAType" ] == "Secondary":
		del palanthir.getcv()[ "SASecondaryIcon" ]
	return 0

def onIconDblClick( Gump, GumpObject ):
	if Gump.cv[ "SAType" ] == "Primary":
		if Gump.cv[ "Image" ].hue == 0x26:
			SelectAbility( 0 )
		else:
			SelectAbility( GetPrimaryAbility() )
			Gump.cv[ "Image" ].hue = 0x26
		return 1
	elif Gump.cv[ "SAType" ] == "Secondary":
		if Gump.cv[ "Image" ].hue == 0x26:
			SelectAbility( 0 )
		else:
			SelectAbility( GetSecondaryAbility() )
			Gump.cv[ "Image" ].hue = 0x26
		return 1
	return 1

def SelectAbility( Ability ):	
	packet = palanthir.newpacket( 0xD7, 15 )
	packet.setword( 1, 15 )
	packet.setlongword( 3, palanthir.world.getplayer().serial )
	packet.setword( 7, 0x19 )
	packet.setlongword( 9, 0 )
	packet.setbyte( 13, Ability )
	packet.setbyte( 14, 7 )
	packet.send()
	return 0

def onLoad():
	palanthir.registerpackethandler( 0xBF, onPacket )
	return 0

def onPacket( Packet ):
	if Packet.getword( 3 ) == 0x21:
		if palanthir.getcv().has_key( "SAPrimaryIcon" ):
			palanthir.getcv()[ "SAPrimaryIcon" ].cv[ "Image" ].hue = 0
		if palanthir.getcv().has_key( "SASecondaryIcon" ):
			palanthir.getcv()[ "SASecondaryIcon" ].cv[ "Image" ].hue = 0
		return 1
	return 0

def onGameEnter():
	if palanthir.charconfig().getbool( "SAPrimaryIcon" ):
		Icon = palanthir.newgump( palanthir.charconfig().getinteger( "SAPrimaryIconX" ), palanthir.charconfig().getinteger( "SAPrimaryIconY" ) )
		Icon.cv[ "SAType" ] = "Primary"
		
		if Weapons.has_key( str( Unarmed ) ):
			PriW = GetAbility( Weapons[ str( Unarmed ) ].primary )[ "GumpId" ]
		else:
			PriW = 0
		Image = Icon.addimage( 0, 0, PriW, 0, 0 )
		Icon.cv[ "Image" ] = Image
		Icon.ondelete = onIconDelete
		Icon.ondblclick = onIconDblClick
		Icon.show()
		Icon = palanthir.getcv()[ "SAPrimaryIcon" ] = Icon
	if palanthir.charconfig().getbool( "SASecondaryIcon" ):
		Icon = palanthir.newgump( palanthir.charconfig().getinteger( "SASecondaryIconX" ), palanthir.charconfig().getinteger( "SASecondaryIconY" ) )
		Icon.cv[ "SAType" ] = "Secondary"
		
		if Weapons.has_key( str( Unarmed ) ):
			SecW = GetAbility( Weapons[ str( Unarmed ) ].secondary )[ "GumpId" ]
		else:
			SecW = 0
		Image = Icon.addimage( 0, 0, SecW, 0, 0 )
		Icon.cv[ "Image" ] = Image
		Icon.ondelete = onIconDelete
		Icon.ondblclick = onIconDblClick
		Icon.show()
		Icon = palanthir.getcv()[ "SASecondaryIcon" ] = Icon		
	return 0

def onGameLeave():
	if palanthir.getcv().has_key( "SAPrimaryIcon" ):
		Icon = palanthir.getcv()[ "SAPrimaryIcon" ]
		palanthir.charconfig().setbool( "SAPrimaryIcon", 1 )
		palanthir.charconfig().setinteger( "SAPrimaryIconX", Icon.x )
		palanthir.charconfig().setinteger( "SAPrimaryIconY", Icon.y )
	else:
		palanthir.charconfig().setbool( "SAPrimaryIcon", 0 )
	if palanthir.getcv().has_key( "SASecondaryIcon" ):
		Icon = palanthir.getcv()[ "SASecondaryIcon" ]
		palanthir.charconfig().setbool( "SASecondaryIcon", 1 )
		palanthir.charconfig().setinteger( "SASecondaryIconX", Icon.x )
		palanthir.charconfig().setinteger( "SASecondaryIconY", Icon.y )
	else:
		palanthir.charconfig().setbool( "SASecondaryIcon", 0 )
	return 0

def onAddItemToChar( char, item ):
	if char == palanthir.world.getplayer() and ( item.layer == 1 or item.layer == 2 ):
		UpdateIconIds()
	return 0

def onRemoveItemFromChar( char, item ):
	if char == palanthir.world.getplayer() and ( item.layer == 1 or item.layer == 2 ):
		UpdateIconIds()
	return 0