import palanthir

def onLoad():
	palanthir.registerpackethandler( 0xAB, onPacket )
	return 0

def onPacket( Packet ):
	Gump = palanthir.newgump( 120, 100 )
	
	Gump.cv[ "serial" ] = GetSerial( Packet )
	Gump.cv[ "max" ] = GetFormat( Packet )
	
	Gump.addimage( 0, 0, 0x474, 0, 0 )
	Gump.addhtmlgump( 62, 50, 270, 50, GetText( Packet ), 0, 0, 0 )
	Gump.addimage( 60, 130, 0x477, 0, 0 )
	Gump.addtext( 62, 110, GetText2( Packet ), 0, 0, 0 )
	if GetStyle( Packet ) == 2:
		Gump.addinputfield( 73, 132, 200, 20, '', 0, 1, 0, 0, 1 )
	else:
		Gump.addinputfield( 73, 132, 200, 20, '', 0, 1, 0, 0, 0 )
	Gump.addbutton( 200, 195, 0x478, 0x479, 0, 0, 0x47A )
	Gump.addbutton( 120, 195, 0x47B, 0x47C, 1, 0, 0x47D )
	Gump.onbuttonclick = onButtonClick
	Gump.show()
	return 1

def onButtonClick( Gump, ReturnNumber ):
	if ReturnNumber == 1:
		Text = Gump.getinputfieldtext( 1 )
		TextLength = len( Text ) + 1
		
		Packet = palanthir.newpacket( 0xAC, 12 + TextLength )
		Packet.setword( 1, 12 + TextLength )
		Packet.setlongword( 3, Gump.cv[ "serial" ] )
		Packet.setbyte( 7, 0 )
		Packet.setbyte( 8, 0 )
		Packet.setbyte( 9, 1 )
		Packet.setword( 10, TextLength )
		Packet.setasciistring( 12, Text, TextLength )
		Packet.send()
		Gump.delete()
		return 1
	elif ReturnNumber == 2:
		TextLength = 1
		
		Packet = palanthir.newpacket( 0xAC, 12 + TextLength )
		Packet.setword( 1, 12 + TextLength )
		Packet.setlongword( 3, Gump.cv[ "serial" ] )
		Packet.setbyte( 7, 0 )
		Packet.setbyte( 8, 0 )
		Packet.setbyte( 9, 0 )
		Packet.setword( 10, TextLength )
		Packet.setbyte( 12, 0, 1 )	#zero string
		Packet.send()
		Gump.delete() 
		return 1
	return 0

def GetSerial( Packet ):
	return Packet.getlongword( 3 )

def GetParentId( Packet ):
	return Packet.getbyte( 7 )

def GetButtonId( Packet ):
	return Packet.getbyte( 8 )

def GetTextLen( Packet ):
	return Packet.getword( 9 )

def GetText( Packet ):
	return Packet.getasciistring( 11, GetTextLen( Packet ) )

def GetCancel( Packet ):
	return Packet.getbyte( 11 + GetTextLen( Packet ) )

def GetStyle( Packet ):
	return Packet.getbyte( 12 + GetTextLen( Packet ) )

def GetFormat( Packet ):
	return Packet.getlongword( 13 + GetTextLen( Packet ) )

def GetText2Len( Packet ):
	return Packet.getword( 17 + GetTextLen( Packet ) )

def GetText2( Packet ):
	return Packet.getasciistring( 19 + GetTextLen( Packet ), GetText2Len( Packet ) )