import palanthir

GUMP_ITEM = 0x23A
GUMP_CHAR = 0x23B

PrioList = [ 22, 23, 4, 3, 2, 21, 13, 9, 10, 15, 16, 17, 7, 11, 12, 19, 8, 20, 6, 1, 24, 17, 14, 5 ]

def onLoad():
	palanthir.registerpackethandler( 0xF5, onObjectInfo )
	return 0

def ItemCompare( Item1, Item2 ):
	if Item1.layer >= len( PrioList ):
		Prio1 = 0
	else:
		Prio1 = PrioList[ Item1.layer ]
	if Item2.layer >= len( PrioList ):
		Prio2 = 0
	else:
		Prio2 = PrioList[ Item2.layer ]
	if Prio1 < Prio2:
		return -1
	elif Prio1 > Prio2:
		return 1
	else:
		return 0

def onObjectInfo( Packet ):
	if Packet.getbyte( 3 ) == 0x14:
		Char = palanthir.world.getchar( Packet.getlongword( 4 ) )
		if not Char:
			return 0
		Gump = GetObjectInfoGump()
		Gump.cv[ "serial" ] = Char.serial
		
		Gump.cv[ "charpdbody" ].id = palanthir.data.getanimgumpid( Char.id )
		Gump.cv[ "charpdbody" ].hue = Char.color
		for Item in Gump.cv[ "charpditems" ]:
			Gump.deleteobject( Item )
		Gump.cv[ "charpditems" ] = []
		
		ItemList = []
		for Item in Char.content:
			if Item.layer > 0 and Item.layer < 25 and Item.layer != 0x15:
				ItemList += [Item]
		
		ItemList.sort( ItemCompare )		
		for Item in ItemList:
			if palanthir.data.getstatictileentry( Item.id )[ "partialhue" ]:
				Color = Item.color + 0x8000
			else:
				Color = Item.color
			ItemImage = Gump.addimage( 30, 20, palanthir.data.getstatictileentry( Item.id )[ "animid" ] + 50000, Color, 3, 80, 80, 1 )
			Gump.cv[ "charpditems" ] += [ItemImage]

		PP = 8
		NameLength = Packet.getbyte( PP )
		PP += 1
		Gump.cv[ "charname" ].text = Packet.getasciistring( PP, NameLength )
		PP += NameLength
		
		RaceLength = Packet.getbyte( PP )
		PP +=1
		Gump.cv[ "charrace" ].text = Packet.getasciistring( PP, RaceLength )
		PP += RaceLength
		
		ProfileLength = Packet.getword( PP )
		PP += 2
		Gump.cv[ "charprofile" ].text = Packet.getasciistring( PP, ProfileLength )
		PP += ProfileLength
		
		Hitpoints = Packet.getbyte( PP )
		Gump.cv[ "charhitpoints" ].current = Hitpoints
		Gump.cv[ "charhitpoints" ].text = str( Hitpoints ) + "%"		
		
		Gump.activepage = 3
		return 1
	elif Packet.getbyte( 3 ) == 0x15:
		Item = palanthir.world.getitem( Packet.getlongword( 4 ) )
		if not Item:
			return 0
		Gump = GetObjectInfoGump()
		Gump.cv[ "serial" ] = Item.serial
		
		PP = 8
		ClilocID = Packet.getlongword( PP )
		PP += 4
		if ClilocID != -1:
			Gump.cv[ "itemname" ].text = palanthir.data.getclilocmessage( ClilocID )
		else:	
			NameLength = Packet.getbyte( PP )
			PP += 1
			Gump.cv[ "itemname" ].text = Packet.getasciistring( PP, NameLength )
			PP += NameLength
		
		Amount = Packet.getword( PP )
		PP += 2
		Gump.cv[ "itemamount" ].text = str( Amount )
		
		Gump.cv[ "itemimage" ].id = palanthir.data.getamountid( Item.id, Amount )
		Gump.cv[ "itemimage" ].hue = Item.color
		ItemImage = Gump.cv[ "itemimage" ]
		ItemImage.x = 20 + max( 0, (80-ItemImage.texturewidth) / 2 )
		ItemImage.y = 20 + max( 0, (80-ItemImage.textureheight) / 2 )
		
		Gump.cv[ "itemweight" ].text = str( Packet.getword( PP ) )
		PP += 2
		Gump.cv[ "itemvolume" ].text = str( Packet.getword( PP ) )
		PP += 2
		IdentLength = Packet.getword( PP )
		PP += 2
		Gump.cv[ "itemidentification" ].text = Packet.getasciistring( PP, IdentLength )
		Gump.activepage = 2
		return 1
	return 0

def onMouseStayOver( Object ):
	if palanthir.isme():
		if Object.isitem or Object.ischar:
			Packet = palanthir.newpacket( 0xF5, 8 )
			Packet.setword( 1, 8 )
			Packet.setbyte( 3, 0x13 )
			Packet.setlongword( 4, Object.serial )
			Packet.send()
			return 1
	return 0

def GetObjectInfoGump():
	if palanthir.getcv().has_key( "objectinfo" ):
		return palanthir.getcv()[ "objectinfo" ]
	else:
		X = palanthir.charconfig().getinteger( "ObjectInfoX" )
		if X == 0:
			X = 100
		Y = palanthir.charconfig().getinteger( "ObjectInfoY" )
		if Y == 0:
			Y = 100
		Gump = palanthir.newgump( X, Y )
		palanthir.getcv()[ "objectinfo" ] = Gump
		Gump.ondelete = onDelete
		
		#Item
		Gump.cv[ "itembackground" ] = Gump.addimage( 0, 0, GUMP_ITEM, 0, 2 )
		Gump.cv[ "itemimage" ] = Gump.addtilepic( 0, 0, 0, 0, 2 )
		Gump.cv[ "itemimage" ].width = 80
		Gump.cv[ "itemimage" ].height = 80
		Gump.cv[ "itemamount" ] = Gump.addtext( 65, 80, "", 0, 0x1, 2, 0 )
		Gump.cv[ "itemname" ] = Gump.addtext( 115, 20, "", 0, 0x1, 2, 0 )
		Gump.cv[ "itemweight" ] = Gump.addtext( 140, 50, "", 0, 0x1, 2, 0 )
		Gump.cv[ "itemvolume" ] = Gump.addtext( 140, 80, "", 0, 0x1, 2, 0 )
		Gump.cv[ "itemidentification" ] = Gump.addcroppedtext( 25, 115, 220, 190, "", 0, 1, 2, -1, 0 )
		
		#Char
		Gump.cv[ "charbackground" ] = Gump.addimage( 0, 0, GUMP_CHAR, 0, 3 )
		Gump.cv[ "charbackbackground" ] = Gump.addhuebutton( 20, 20, 80, 80, 0, 0, 0, 0, 3 )
		Gump.cv[ "charname" ] = Gump.addtext( 115, 20, "blub", 0, 0x1, 3, 0 )
		Gump.cv[ "charrace" ] = Gump.addtext( 115, 50, "blub2", 0, 0x1, 3, 0 )
		Gump.cv[ "charhitpoints" ] = Gump.addprogressbar( 110, 80, 140, 20, 0, 100, 0, 0, 0x00FF00, 0xFFFFFF, "", "CENTER", 0xFFFFFF, 1, 3 )
		Gump.cv[ "charprofile" ] = Gump.addcroppedtext( 25, 115, 220, 190, "", 0, 1, 3, -1, 0 )
		Gump.cv[ "charpdbody" ] = Gump.addimage( 30, 20, 0x0, 0, 3, 80, 80, 1 )
		Gump.cv[ "charpditems" ] = []
		
		Gump.show()
		return Gump

def onDelete( Gump ):
	palanthir.charconfig().setinteger( "ObjectInfoX", Gump.x )
	palanthir.charconfig().setinteger( "ObjectInfoY", Gump.y )
	del palanthir.getcv()[ "objectinfo" ]
	return 0