import palanthir
from fightbook import OpenSpecialAbilityGump

PrioList = [ 22, 23, 4, 3, 2, 21, 13, 9, 10, 15, 16, 17, 7, 11, 12, 19, 8, 20, 6, 1, 24, 17, 14, 5 ]

def ItemCompare( Item1, Item2 ):
	if PrioList[ Item1.layer ] < PrioList[ Item2.layer ]:
		return -1
	elif PrioList[ Item1.layer ] > PrioList[ Item2.layer ]:
		return 1
	else:
		return 0

#Status and Options missing yet
#def onLoad():
#	if not palanthir.isme():
#		palanthir.registerpackethandler( 0x88, onPacket )
#	return 0

def onPacket( Packet ):
	Serial = Packet.getlongword( 1 )
	Text = Packet.getasciistring( 5, 60 )
	
	if palanthir.getcv().has_key( "Paperdoll" + str( Serial ) ):
		palanthir.getcv()[ "Paperdoll" + str( Serial ) ].cv[ "Text" ].text = Text
	else:		
		X = palanthir.charconfig().getinteger( "PaperdollX" )
		if X == 0:
			X = 100
		Y = palanthir.charconfig().getinteger( "PaperdollY" )
		if Y == 0:
			Y = 100
		
		Char = palanthir.world.getchar( Serial )
		if not Char:
			return 1
		
		Gump = palanthir.newgump( X, Y )
		Gump.cv[ "Serial" ] = Serial
		Gump.ondelete = onDelete
		Gump.onmouseup = onMouseUp
		Gump.ondblclick = onDblClick
		Gump.onbuttonclick = onButtonClick
		
		if Char.isplayer:
			Gump.cv[ "Background" ] = Gump.addimage( 0, 0, 0x7D0, 0, 0 )
		else:
			Gump.cv[ "Background" ] = Gump.addimage( 0, 0, 0x7D1, 0, 0 )
		
		Gump.cv[ "Char" ] = Gump.addimage( 10, 20, palanthir.data.getanimgumpid( Char.id ), Char.color, 0 )
		
		Gump.cv[ "Text" ] = Gump.addcroppedtext( 40, 260, 180, 40, Text, 0, 0, 0, 2 )
		
		Gump.cv[ "Profile" ] = Gump.addbutton( 20, 195, 0x7D2, 0x7D2, 9, 0 )
		if Char.isplayer:
			Gump.cv[ "Peace" ] = Gump.addbutton( 185, 205, 0x7E5, 0x7E6, 2, 0, 0x7E7 ) #Peace/War
			Gump.addbutton( 185, 177, 0x7E2, 0x7E3, 3, 0, 0x7E4 ) #Chat
			Gump.addbutton( 185, 149, 0x7DF, 0x7E0, 4, 0, 0x7E1 ) #Skills
			Gump.addbutton( 185, 121, 0x7DC, 0x7DD, 5, 0, 0x7DE ) #Journal
			Gump.addbutton( 185, 91, 0x7D9, 0x7DA, 6, 0, 0x7DB ) #Quit
			Gump.addbutton( 185, 65, 0x7D6, 0x7D7, 7, 0, 0x7D8 ) #Optionen
			Gump.addbutton( 185, 37, 0x7EF, 0x7F0, 8, 0, 0x7F1 ) #Help
			Gump.cv[ "Party" ] = Gump.addbutton( 34, 195, 0x7D2, 0x7D2, 10, 0, 0x7D2 ) #Partysys
			Gump.cv[ "SABook" ] = Gump.addimage( 155, 197, 0x2B34, 0, 0 )
		
		Gump.addbutton( 185, 233, 0x7EB, 0x7EC, 1, 0, 0x7ED ) #Status
		
		updateItems( Gump )
		
		Gump.show()
		
		palanthir.getcv()[ "Paperdoll" + str( Serial ) ] = Gump
	return 1

def onDelete( Gump ):
	if palanthir.getcv().has_key( "Paperdoll" + str( Gump.cv[ "Serial" ] ) ):
		del palanthir.getcv()[ "Paperdoll" + str( Gump.cv[ "Serial" ] ) ]

def updateItems( Gump ):
	if Gump.cv.has_key( "items" ):
		for Image in Gump.cv[ "items" ]:
			Gump.deleteobject( Image )
	
	Char = palanthir.world.getchar( Gump.cv[ "Serial" ] )
	if not Char:
		return 0
	
	Gump.cv[ "items" ] = []
	ItemList = []
	for Item in Char.content:
		if Item.layer > 0 and Item.layer < 25:
			ItemList += [Item]			
		
	ItemList.sort( ItemCompare )		
	for Item in ItemList:
		ItemImage = Gump.addgumpitem( 10, 20, Item.serial, -1, 0 )
		Gump.cv[ "items" ] += [ItemImage]
	
	Gump.cv[ "SABook" ].sendfront()
	return 0

def onMouseUp( Gump, GumpObject ):
	if palanthir.mouse().dragserial > 0:
		if GumpObject.isgumpitem:
			Item = palanthir.world.getitem( GumpObject.itemserial )
			if Item and (Item.layer == 21):
				DropItem( Item )
				return 0
		EquipItem( Gump )	
	return 0

def onButtonClick( Gump, ReturnNumber ):
	if ReturnNumber == 2:
		Char = palanthir.world.getchar( Gump.cv[ "Serial" ] )
		if Char:
			if Char.warmode:
				Char.warmode = 0
			else:
				Char.warmode = 1
		return 1
	elif ReturnNumber == 4:
		SendSkillRequest( Gump.cv[ "Serial" ] )
		return 1
	elif ReturnNumber == 5:
		palanthir.openjournal()
		return 1
	elif ReturnNumber == 6:
		OpenDisconnectConfirm()
		return 1
	elif ReturnNumber == 8:
		SendHelpRequest()
		return 1
	return 0

def onDblClick( Gump, GumpObject ):
	if Gump.cv.has_key( "SABook" ) and GumpObject == Gump.cv[ "SABook" ]:
		OpenSpecialAbilityGump()
		return 1
	elif GumpObject == Gump.cv[ "Profile" ]:
		SendProfileRequest( Gump.cv[ "Serial" ] )
		return 1
	return 0

def onAddItemToChar( char, item ):
	if palanthir.getcv().has_key( "Paperdoll" + str( char.serial ) ):
		Gump = palanthir.getcv()[ "Paperdoll" + str( char.serial ) ]
		updateItems( Gump )
	return 0

def onRemoveItemFromChar( char, item ):
	if palanthir.getcv().has_key( "Paperdoll" + str( char.serial ) ):
		Gump = palanthir.getcv()[ "Paperdoll" + str( char.serial ) ]
		updateItems( Gump )
	return 0

def onWarModeChange( WarMode ):
	Serial = palanthir.world.getplayer().serial
	if palanthir.getcv().has_key( "Paperdoll" + str( Serial ) ):
		Gump = palanthir.getcv()[ "Paperdoll" + str( Serial ) ]
		if WarMode:
			Gump.cv[ "Peace" ].upid = 0x7E8
			Gump.cv[ "Peace" ].downid = 0x7E9
			Gump.cv[ "Peace" ].moveoverid = 0x7EA
		else:
			Gump.cv[ "Peace" ].upid = 0x7E5
			Gump.cv[ "Peace" ].downid = 0x7E6
			Gump.cv[ "Peace" ].moveoverid = 0x7E7
	return 0

def DropItem( Item ):
	packet = palanthir.newpacket( 0x8, 14 )
	packet.setlongword( 1, palanthir.mouse().dragserial )
	packet.setword( 5, 0xFFFF )
	packet.setword( 7, 0xFFFF )
	packet.setbyte( 9, 0xFF )
	packet.setlongword( 10, Item.serial )
	packet.send()
	palanthir.mouse().dragserial = -1
	return 0

def EquipItem( Gump ):
	packet = palanthir.newpacket( 0x13, 10 )
	packet.setlongword( 1, palanthir.mouse().dragserial )
	packet.setbyte( 5, palanthir.mouse().draglayer )
	packet.setlongword( 6, Gump.cv[ "Serial" ] )
	packet.send()
	palanthir.mouse().dragserial = -1
	return 0

def SendHelpRequest():
	packet = palanthir.newpacket( 0x9B, 258 )
	for i in range( 1, 258 ):
		packet.setbyte( i, 0 )
	packet.send()
	return 0

def SendSkillRequest( Serial ):
	packet = palanthir.newpacket( 0x34, 10 )
	packet.setlongword( 1, 0xEDEDEDED )
	packet.setbyte( 5, 5 )
	packet.setlongword( 6, Serial )
	packet.send()
	return 0

def SendProfileRequest( Serial ):
	packet = palanthir.newpacket( 0xB8, 8 )
	packet.setword( 1, 8 )
	packet.setbyte( 3, 0 )
	packet.setlongword( 4, Serial )
	packet.send()
	return 0

def OpenDisconnectConfirm():
	Gump = palanthir.newgump( 200, 200 )
	Gump.nomove = 1
	Gump.onbuttonclick = onDisconnectButtonClick
	
	Gump.addimage( 0, 0, 0x816, 0, 0 )
	if palanthir.isme():
		Gump.addbutton( 25, 74, 0x22E, 0x22D, 0, 0, 0x22E )
		Gump.addbutton( 109, 74, 0x75, 0x74, 1, 0, 0x75 )
		Gump.addtext( 35, 27, "Quit", 0, 0x481, 0 )
		Gump.addtext( 35, 42, "Ultima Online?", 0, 0x481, 0 )
	else:
		Gump.addbutton( 36, 78, 0x817, 0x818, 0, 0, 0x819 )
		Gump.addbutton( 99, 78, 0x81A, 0x81B, 1, 0, 0x81C )
		Gump.addtext( 35, 27, "Quit", 0, 0, 0 )
		Gump.addtext( 35, 42, "Ultima Online?", 0, 0, 0 )
	Gump.show()
	return 0

def onDisconnectButtonClick( Gump, ReturnNumber ):
	if ReturnNumber == 1:
		palanthir.returntologin()
		return 0
	Gump.delete()
	return 1
