import palanthir

def onLoad():
	palanthir.registerpackethandler( 0xA8, onPacket )
	return 0

def onPacket( Packet ):
	if palanthir.isme():
		palanthir.setshardname( GetServerName( Packet, 0 ) )
		SelectServer( GetServerIndex( Packet, 0 ) )
	else:
		Gump = palanthir.newgump( 0, 0 )
		Gump.noclose = 1
		Gump.nomove = 1
		Gump.cv[ "SelectedShardNr" ] = 0
		Gump.cv[ "ShardIndizes" ] = []
		Gump.cv[ "ShardNames" ] = []
		
		Gump.onbuttonclick = onButtonClick
		Gump.ondblclick = onDblClick
		Gump.onkeyreturn = onKeyReturn
		
		Gump.addtiledimage( 0, 0, 640, 480, 0x588, 0, 0 )
		Gump.addimage( 0, 0, 0x157C, 0, 0 )
		Gump.addimage( 0, 0, 0x15A0, 0, 0 )
		Gump.addbutton( 555, 5, 0x1589, 0x158B, 1, 0, 0x158A )
		Gump.addbutton( 610, 440, 0x15A4, 0x15A6, 2, 0, 0x15A5 )
		
		Gump.addresizegump( 200, 100, 400, 250, 0xDAC, 0, 0 )
		
		for i in range( 0, GetServerCount( Packet ) ):
			Gump.addtextbutton( 230, 120+i*30, i+3, GetServerName( Packet, i ), 0, 0, 250, 0, 0x481, 0x481 )
			Gump.cv[ "ShardIndizes" ] += [GetServerIndex( Packet, i )]
			Gump.cv[ "ShardNames" ]+= [GetServerName( Packet, i )]
		
		Gump.addimage( 250, 360, 0x589, 0, 0 )
		Gump.addbutton( 261, 370, 0x15E8, 0x15EA, 10, 0, 0x15E9 )
		
		Gump.cv[ "SelectedShardName" ] = Gump.addtext( 340, 380, "", 0, 2, 0 )
		Gump.show()
	return 1

def SelectServer( Server ):
	Packet = palanthir.newpacket( 0xA0, 3 )
	Packet.setword( 1, Server )
	Packet.send()
	return 0

def GetServerCount( Packet ):
	return Packet.getword( 4 )

def GetServerIndex( Packet, Server ):
	return Packet.getword( 6 + Server*40 )

def GetServerName( Packet, Server ):
	return Packet.getasciistring( 6 + Server*40 + 2, 32 )

def GetServerPercentFull( Packet, Server ):
	return Packet.getbyte( 6 + Server*40 + 34 )

def GetServerTimeZone( Packet, Server ):
	return Packet.getbyte( 6 + Server*40 + 35 )

def GetServerPingIP( Packet, Server ):
	return Packet.getlongword( 6 + Server*40 + 36 )

def onButtonClick( Gump, ReturnNumber ):
	if ReturnNumber == 1:
		Gump.delete()
		palanthir.returntologin()
		return 1
	elif ReturnNumber in [2,10]:
		palanthir.setshardname( Gump.cv[ "ShardNames" ][ Gump.cv[ "SelectedShardNr" ] ] )
		SelectServer( Gump.cv[ "ShardIndizes" ][ Gump.cv[ "SelectedShardNr" ] ] )
		Gump.delete()
	elif ReturnNumber in range( 3, 9 ):
		Gump.cv[ "SelectedShardNr" ] = ReturnNumber-3
		Gump.cv[ "SelectedShardName" ].text = Gump.cv[ "ShardNames" ][ ReturnNumber-3 ]
	return 0

def onDblClick( Gump, GumpObject ):
	if GumpObject.istextbutton:
		if GumpObject.returnnumber in range( 3, 9 ):
			Gump.cv[ "SelectedShardNr" ] = GumpObject.returnnumber-3
			onButtonClick( Gump, 2 )
			return 1
	return 0

def onKeyReturn( Gump, GumpObject ):
	onButtonClick( Gump, 2 )
	return 1