import palanthir

BACKUPPERID = 0x1F40
BACKLOWERID = 0x1F43
BACKMIDDLEID1 = 0x1F41
BACKMIDDLEID2 = 0x1F42
UPID = 0x824
DOWNID = 0x825
SIGNID = 0x828
LOCKID = 0x82C
CAPUPID = 0x983
CAPUPMOVEOVERID = 0x984
CAPDOWNID = 0x985
CAPDOWNMOVEOVERID = 0x986
DECORATION = 0x82B
UPPERBUTTON = 0x82D
MOVEBUTTON = 0x82E
MOVEBUTTONPRESSED = 0x82F
SMALLSKILLSSYMBOL = 0x839
SKILLSNAME = 0x834
DIVISORID = 0x835
DESCRIPTIONTEXT = 0x836
SKILLBUTTON = 0x837
SKILLBUTTONMOVEOVER = 0x838
NEWGROUPBACKGROUND = 0x98D
BUTTONGREEN = 0x939
BUTTONRED = 0x938
ARROWRIGHT = 0x827
ARROWDOWN = 0x826

def SkillCompare( Skill1, Skill2 ):
	return cmp( Skill1.name.lower(), Skill2.name.lower() )

class SkillGroup:
	def __init__( self, gump, id, name ):
		self.gump = gump
		self.id = id
		self.name = name
		self.extended = 0
		self.skills = []
		self.nametext = gump.addinputfield( 44, 0, 200, 20, name, 0, id, 2, 0 )
		self.nametext.border = 0
		self.nametext.cv[ "group" ] = self
		self.arrow = gump.addbutton( 29, 0, ARROWRIGHT, ARROWRIGHT, 100+id, 0, ARROWRIGHT, 1 )
		self.line = gump.addtiledimage( 44 + self.nametext.texturewidth, 0, max( 0, 200 - self.nametext.texturewidth ), 4, DIVISORID, 0, 0 )
	
	def setname( self, name ):
		self.name = name
		self.nametext.text = name
		self.line.x = 44 + self.nametext.texturewidth
		self.line.width = max( 0, 200 - self.nametext.texturewidth )
		return 0
	
	def addskill( self, id, name, hasbutton ):
		newskill = Skill( self.gump, id, name, hasbutton )
		self.skills += [newskill]
		newskill.group = self
		return newskill
	
	def moveskill( self, skill ):
		self.skills += [skill]
		skill.group = self
		return 0
	
	def removeskill( self, skill ):
		for i in range( 0, len( self.skills ) ):
			if self.skills[ i ] == skill:
				del self.skills[ i ]
				break
		return 0
	
	def sortskills( self ):
		self.skills.sort( SkillCompare )
		return 0
	
	def click( self ):
		if self.extended:
			self.extended = 0
			self.arrow.upid = ARROWRIGHT
			self.arrow.downid = ARROWRIGHT
			self.arrow.moveoverid = ARROWRIGHT
			for skill in self.skills:
				skill.hide()
		else:
			self.extended = 1
			self.arrow.upid = ARROWDOWN
			self.arrow.downid = ARROWDOWN
			self.arrow.moveoverid = ARROWDOWN
			for skill in self.skills:
				skill.show()
		return 0
	
	def show( self, y=0 ):
		self.nametext.page = 0
		self.nametext.y = y
		self.arrow.page = 0
		self.arrow.y = y+3
		self.line.page = 0
		self.line.y = y+8
		return 0
	
	def hide( self ):
		self.nametext.page = 2
		self.arrow.page = 2
		self.line.page = 2
		return 0
	
class Skill:
	def __init__( self, gump, id, name, hasbutton ):
		self.gump = gump
		self.id = id
		self.name = name
		self.hasbutton = hasbutton
		self.cap = 0
		self.value = 0
		self.valuemod = 0
		self.lock = 0
		self.group = 0
		
		if self.hasbutton:
			self.button = gump.addbutton( 36, 0, SKILLBUTTON, SKILLBUTTONMOVEOVER, 1000+id, 2, SKILLBUTTONMOVEOVER )
		else:
			self.button = 0
		self.text = gump.addtext( 50, 0, name, 1, 0x223, 2, 0 )
		self.text.cv[ "skill" ] = self
		self.valuetext = gump.addtext( 275, 0, "0.0", 1, 0x223, 2, 0 )
		self.valuetext.x = 275 - self.valuetext.texturewidth
		self.arrow = gump.addbutton( 278, 0, CAPUPID, CAPUPMOVEOVERID, 1100+id, 2, CAPUPMOVEOVERID )
	
	def update( self, valuemod, value, lock, cap ):
		self.valuemod = valuemod		
		self.value = value
		self.cap = cap				
		
		self.updatelock( lock )
		self.updatevalue()
		return 0
	
	def updatevalue( self ):
		if self.gump.cv[ "ShowCaps" ]:
			self.valuetext.text = str( self.cap / 10 ) + "." + str( self.cap % 10 )
			self.valuetext.x = 275 - self.valuetext.texturewidth
		elif self.gump.cv[ "ShowReal" ]:
			self.valuetext.text = str( self.value / 10 ) + "." + str( self.value % 10 )
			self.valuetext.x = 275 - self.valuetext.texturewidth
		else:
			self.valuetext.text = str( self.valuemod / 10 ) + "." + str( self.valuemod % 10 )
			self.valuetext.x = 275 - self.valuetext.texturewidth
		return 0
	
	def updatelock( self, lock ):
		self.lock = lock
		if lock == 0:
			self.arrow.upid = CAPUPID
			self.arrow.downid = CAPUPMOVEOVERID
			self.arrow.moveoverid = CAPUPMOVEOVERID
		elif lock == 1:
			self.arrow.upid = CAPDOWNID
			self.arrow.downid = CAPDOWNMOVEOVERID
			self.arrow.moveoverid = CAPDOWNMOVEOVERID
		else:
			self.arrow.upid = LOCKID
			self.arrow.downid = LOCKID
			self.arrow.moveoverid = LOCKID
		return 0
		
	def show( self, y=0 ):
		if self.hasbutton:
			self.button.page = 0
			self.button.y = y+4
		
		self.text.page = 0
		self.text.y = y
		self.valuetext.page = 0
		self.valuetext.y = y
		self.arrow.page = 0
		self.arrow.y = y+4
		return 0
	
	def hide( self ):
		if self.hasbutton:
			self.button.page = 2
		self.text.page = 2
		self.valuetext.page = 2
		self.arrow.page = 2
		return 0
	
	def removefromgroup( self ):
		if self.group:
			OldGroup = self.group
			self.group.removeskill( self )
			self.group = 0
			return OldGroup
		else:
			return 0
		

def onLoad():
	palanthir.registerpackethandler( 0x3A, onPacket )
	return 0

def onPacket( packet ):
	Gump = OpenSkillGump()
	type = packet.getbyte( 3 )	
	if type == 0x0 or type == 0x2:
		id = packet.getword( 4 )
		pos = 6
		while id != 0:
			valuemod = packet.getword( pos )
			pos += 2
			value = packet.getword( pos )
			pos += 2
			lock = packet.getbyte( pos )
			pos += 1
			if type == 0x2:
				cap = packet.getword( pos )
				pos += 2
			else:
				cap = 1000
			
			if id < Gump.cv[ "Skills" ]:
				Gump.cv[ "Skills" ][ id-1 ].update( valuemod, value, lock, cap )
			id = packet.getword( pos )
			pos += 2
		UpdateTotalSkill( Gump )
	elif type == 0xFF or type == 0xDF:
		id = packet.getword( 4 )
		valuemod = packet.getword( 6 )
		value = packet.getword( 8 )
		lock = packet.getbyte( 10 )
		if type == 0xDF:
			cap = packet.getword( 11 )
		else:
			cap = 1000
		if id < Gump.cv[ "Skills" ]:
			Gump.cv[ "Skills" ][ id ].update( valuemod, value, lock, cap )
		return 1
	else:
		palanthir.log( "unknown skills packet type: " + str( type ) )
	return 1

def OpenSkillGump():
	if palanthir.getcv().has_key( "skillgump" ):
		return palanthir.getcv()[ "skillgump" ]
	
	X = palanthir.charconfig().getinteger( "SkillGumpX" )
	if X == 0:
		X = 100
	Y = palanthir.charconfig().getinteger( "SkillGumpY" )
	if Y == 0:
		Y = 100
	Gump = palanthir.newgump( X, Y )
	Gump.ondelete = onDelete
	Gump.onmovegump = onMoveGump
	Gump.onscrollbarchange = onScrollBarChange
	Gump.oninputfieldchange = onInputFieldChange
	Gump.onbuttonclick = onButtonClick
	Gump.onmouseup = onMouseUp
	Gump.activepage = 1
	
	Gump.cv[ "ShowReal" ] = 0
	Gump.cv[ "ShowCaps" ] = 0
	
	height = 200
	Gump.cv[ "FirstEntry" ] = 0
	
	Gump.cv[ "RoleUp" ] = Gump.addimage( 0, 23, BACKUPPERID, 0, 1 )
        Gump.cv[ "RoleDown" ] = Gump.addimage( 21, 60+height, BACKLOWERID, 0, 1 )
        Gump.cv[ "DecorationUp" ] = Gump.addimage( 65, 59, DECORATION, 0, 1 )
        Gump.addimage( 150, 34, SKILLSNAME, 0, 1 )
        
        Gump.cv[ "ScrollButtonUp" ] = Gump.addimage( 290, 55, UPID, 0, 1 )
        Gump.cv[ "ScrollButtonDown" ] = Gump.addimage( 290, 60+height-17, DOWNID, 0, 1 )
        Gump.cv[ "DecorationDown" ] = Gump.addimage( 65, 59+height-36, DECORATION, 0, 1 )
        Gump.cv[ "Description" ] = Gump.addimage( 30, 59+height-23, DESCRIPTIONTEXT, 0, 1 )

        Gump.cv[ "MoveButton" ] = Gump.addbutton( 165, 60+height+32, MOVEBUTTON, MOVEBUTTONPRESSED, 1, 1 )
	Gump.cv[ "Height" ] = height
	Gump.cv[ "MiddleList" ] = []
	
	Gump.cv[ "ScrollBar" ] = Gump.addscrollbar( 295, 70, 0, height-30, SIGNID, SIGNID, 1, 1 )
	Gump.cv[ "TotalSkills" ] = Gump.addtext( 0, 59+height-19, "0.0", 0, 0x481, 0, 1 )
	Gump.cv[ "TotalSkills" ].x = 292 - Gump.cv[ "TotalSkills" ].texturewidth
	
	Gump.cv[ "ButtonShowReal" ] = Gump.addbutton( 203, 59+height+6, BUTTONRED, BUTTONRED, 2, 0 )
	Gump.cv[ "ButtonShowRealText" ] = Gump.addtext( 218, 59+height+1, "- Show Real", 1, 1, 0, 0 )
	Gump.cv[ "ButtonShowCaps" ] = Gump.addbutton( 203, 59+height+19, BUTTONRED, BUTTONRED, 3, 0 )
	Gump.cv[ "ButtonShowCapsText" ] = Gump.addtext( 218, 59+height+14, "- Show Caps", 1, 1, 0, 0 )
	
	Gump.cv[ "ButtonAddGroupBackGround" ] = Gump.addbutton( 56, 59+height+7, NEWGROUPBACKGROUND, NEWGROUPBACKGROUND, 4, 0 )
	Gump.cv[ "ButtonAddGroup" ] = Gump.addtextbutton( 79, 59+height+8, 4, "New Group", 1, 0, 60, 0x1, 0x481, 0x481 )
	Gump.cv[ "ButtonAddGroup" ].border = 0
	
	FixMiddle( Gump )
	
	Groups = []
	for id in range( 0, palanthir.data.getskillgroupcount() ):
		Group = SkillGroup( Gump, id, palanthir.data.getskillgroupname( id ) )		
		Groups += [Group]
	
	Skills = []
	for id in range( 0, palanthir.data.getskillcount() ):
		Group = palanthir.data.getskillgroup( id )
		if Group < len( Groups ):
			Skills += [Groups[ Group ].addskill( id, palanthir.data.getskillname( id ), palanthir.data.skillhasbutton( id ) )]
	
	for Group in Groups:
		Group.sortskills()
	
	Gump.cv[ "SkillGroups" ] = Groups
	Gump.cv[ "Skills" ] = Skills
	RearrangeGroups( Gump )
	
	palanthir.getcv()[ "skillgump" ] = Gump
	Gump.show()
	return Gump

def UpdateSkillValues( Gump ):
	for skill in Gump.cv[ "Skills" ]:
		skill.updatevalue()
	UpdateTotalSkill( Gump )
	return 0

def UpdateTotalSkill( Gump ):
	showreal = Gump.cv[ "ShowReal" ]
	showcap = Gump.cv[ "ShowCaps" ]
	total = 0
	for skill in Gump.cv[ "Skills" ]:
		if showreal:
			total += skill.value
		elif showcap:
			total += skill.cap
		else:
			total += skill.valuemod
	Gump.cv[ "TotalSkills" ].text = str( total / 10 ) + "." + str( total % 10 )
	Gump.cv[ "TotalSkills" ].x = 292 - Gump.cv[ "TotalSkills" ].texturewidth
	return 0

def onDelete( Gump ):
	palanthir.charconfig().setinteger( "SkillGumpX", Gump.x )
	palanthir.charconfig().setinteger( "SkillGumpY", Gump.y )
	del palanthir.getcv()[ "skillgump" ]
	return 0

def FixMiddle( Gump ):
	for Object in Gump.cv[ "MiddleList" ]:
		Gump.deleteobject( Object )
		
	Gump.cv[ "MiddleList" ] = []
	
	height = Gump.cv[ "Height" ]
	
	Gump.cv[ "RoleDown" ].y = 60+height
	Gump.cv[ "ScrollButtonDown" ].y = 60+height-17
	Gump.cv[ "DecorationDown" ].y = 59+height-36
	Gump.cv[ "MoveButton" ].y = 60+height+32
	Gump.cv[ "Description" ].y = 59+height-23
	Gump.cv[ "TotalSkills" ].y = 59+height-19
	
	Gump.cv[ "ButtonShowReal" ].y = 59+height+6
	Gump.cv[ "ButtonShowRealText" ].y = 59+height+1
	Gump.cv[ "ButtonShowCaps" ].y = 59+height+19
	Gump.cv[ "ButtonShowCapsText" ].y = 59+height+14
	
	Gump.cv[ "ButtonAddGroupBackGround" ].y = 59+height+7
	Gump.cv[ "ButtonAddGroup" ].y = 59+height+8
	
	if Gump.cv.has_key( "RemoveButton" ):
		Gump.cv[ "RemoveButton" ].y = 60+height+13
	
	for i in range( 0, height / 70 ):	
		if i % 2 == 0:
			image = Gump.addimage( 21, 60+i*70, BACKMIDDLEID1, 0, 1 )
			image.sendback()
			Gump.cv[ "MiddleList" ] += [image]
		else:
			image = Gump.addimage( 21, 60+i*70, BACKMIDDLEID2, 0, 1 )
			image.sendback()
			Gump.cv[ "MiddleList" ] += [image]
			
	image = Gump.addtiledimage( 21, 60+70*(height / 70), 302, height % 70, BACKMIDDLEID2, 0, 1 )
	image.sendback()
	Gump.cv[ "MiddleList" ] += [image]
	
	Gump.cv[ "ScrollBar" ].height = height-30
	Gump.cv[ "ScrollBar" ].promille = min( max( Gump.cv[ "ScrollBar" ].promille, 0 ), 1000 )
		
	return 0

def RearrangeGroups( Gump ):
	first = Gump.cv[ "FirstEntry" ]
	last = first + (Gump.cv[ "Height" ]-56) / 18 - 1
	y = 75
	i = 0
	for group in Gump.cv[ "SkillGroups" ]:
		if i >= first and i <= last:
			group.show( y )			
			y += 18
		else:
			group.hide()		
		i += 1
		
		if group.extended:
			for skill in group.skills:
				if i >= first and i <= last:
					skill.show( y )
					y += 18
				else:
					skill.hide()
				i += 1
		else:
			for skill in group.skills:
				skill.hide()
	Gump.cv[ "EntryCount" ] = i	
	return 0

def onInputFieldChange( Gump, Inputfield ):
	if Inputfield.textid < len( Gump.cv[ "SkillGroups" ] ):
		Gump.cv[ "SkillGroups" ][ Inputfield.textid ].setname( Inputfield.text )
		palanthir.data.setskillgroupname( Inputfield.textid, Inputfield.text )
	return 0

def onButtonClick( Gump, ReturnNumber ):
	if ReturnNumber == 2:
		if Gump.cv[ "ShowReal" ]:
			Gump.cv[ "ShowReal" ] = 0
			Gump.cv[ "ButtonShowReal" ].upid = BUTTONRED
			Gump.cv[ "ButtonShowReal" ].downid = BUTTONRED
			Gump.cv[ "ButtonShowReal" ].moveoverid = BUTTONRED		
		else:
			Gump.cv[ "ShowReal" ] = 1
			Gump.cv[ "ButtonShowReal" ].upid = BUTTONGREEN
			Gump.cv[ "ButtonShowReal" ].downid = BUTTONGREEN
			Gump.cv[ "ButtonShowReal" ].moveoverid = BUTTONGREEN
		Gump.cv[ "ShowCaps" ] = 0
		Gump.cv[ "ButtonShowCaps" ].upid = BUTTONRED
		Gump.cv[ "ButtonShowCaps" ].downid = BUTTONRED
		Gump.cv[ "ButtonShowCaps" ].moveoverid = BUTTONRED
		UpdateSkillValues( Gump )
		return 0
	elif ReturnNumber == 3:
		Gump.cv[ "ShowReal" ] = 0
		Gump.cv[ "ButtonShowReal" ].upid = BUTTONRED
		Gump.cv[ "ButtonShowReal" ].downid = BUTTONRED
		Gump.cv[ "ButtonShowReal" ].moveoverid = BUTTONRED
		if Gump.cv[ "ShowCaps" ]:
			Gump.cv[ "ShowCaps" ] = 0
			Gump.cv[ "ButtonShowCaps" ].upid = BUTTONRED
			Gump.cv[ "ButtonShowCaps" ].downid = BUTTONRED
			Gump.cv[ "ButtonShowCaps" ].moveoverid = BUTTONRED
		else:
			Gump.cv[ "ShowCaps" ] = 1
			Gump.cv[ "ButtonShowCaps" ].upid = BUTTONGREEN
			Gump.cv[ "ButtonShowCaps" ].downid = BUTTONGREEN
			Gump.cv[ "ButtonShowCaps" ].moveoverid = BUTTONGREEN
		UpdateSkillValues( Gump )
		return 0
	elif ReturnNumber == 4:
		Id = palanthir.data.addskillgroup( "New Group" )
		Group = SkillGroup( Gump, Id, "New Group" )
		Gump.cv[ "SkillGroups" ] += [Group]
		RearrangeGroups( Gump )
		return 0
	elif ReturnNumber >= 100 and ReturnNumber < 200:
		Group = ReturnNumber - 100
		if Group < len( Gump.cv[ "SkillGroups" ] ):
			Gump.cv[ "SkillGroups" ][ Group ].click()
			RearrangeGroups( Gump )
			Gump.cv[ "ScrollBar" ].promille = 1000 * Gump.cv[ "FirstEntry" ] / Gump.cv[ "EntryCount" ]
		return 0
	elif ReturnNumber >= 1000 and ReturnNumber < 1100:
		UseSkill( ReturnNumber - 1000 )
		return 0
	elif ReturnNumber >= 1100 and ReturnNumber < 1200:
		if ReturnNumber-1100 < Gump.cv[ "Skills" ]:
			Skill = Gump.cv[ "Skills" ][ ReturnNumber-1100 ]
			if Skill.lock < 2:
				SetSkillLock( Skill.id, Skill.lock+1 )
				Skill.updatelock( Skill.lock+1 )
			else:
				SetSkillLock( Skill.id, 0 )
				Skill.updatelock( 0 )
		return 0
	else:
		return 0

def onMouseUp( Gump, GumpObject ):
	if GumpObject.isinputfield and GumpObject.cv.has_key( "group" ):
		if palanthir.mouse().selecteddownlgumpobject:
			DObject = palanthir.mouse().selecteddownlgumpobject
			if DObject.istext and DObject.gump and DObject.gump == Gump and DObject.cv.has_key( "skill" ):
				Skill = DObject.cv[ "skill" ]									
					
				OldGroup = Skill.removefromgroup()
				if OldGroup:
					OldGroup.sortskills()
								
				NewGroup = GumpObject.cv[ "group" ]
				NewGroup.moveskill( Skill )
				NewGroup.sortskills()
				RearrangeGroups( Gump )
				
				palanthir.data.setskillgroup( Skill.id, NewGroup.id )
	return 0

def onMoveGump( Gump, GumpObject ):
	if GumpObject == Gump.cv[ "MoveButton" ]:		
		height = Gump.cv[ "Height" ]
		
		TmpHeight = height - ( palanthir.mouse().my - palanthir.mouse().y )
		palanthir.mouse().my = palanthir.mouse().y
		palanthir.mouse().mx = palanthir.mouse().x
		
		if TmpHeight > 150 and TmpHeight < 700:
			Gump.cv[ "Height" ] = TmpHeight
			FixMiddle( Gump )
			RearrangeGroups( Gump )
			Gump.cv[ "ScrollBar" ].promille = 1000 * Gump.cv[ "FirstEntry" ] / Gump.cv[ "EntryCount" ]
		return 1
	elif GumpObject.istext or GumpObject.cv.has_key( "skill" ):
		return 1
	return 0

def onScrollBarChange( Gump, GumpObject ):
	Gump.cv[ "FirstEntry" ] = (Gump.cv[ "EntryCount" ]-1) * GumpObject.promille / 1000
	RearrangeGroups( Gump )
	return 0

def UseSkill( id ):
	name = str( id ) + " 0"
	length = 4 + len( name ) + 1
	Packet = palanthir.newpacket( 0x12, length )
	Packet.setword( 1, length )
	Packet.setbyte( 3, 0x24 )
	Packet.setasciistring( 4, name, len( name )+1 )
	Packet.send()
	return 0

def SetSkillLock( id, lock ):
	Packet = palanthir.newpacket( 0x3A, 6 )
	Packet.setword( 1, 6 )
	Packet.setword( 3, id )
	Packet.setbyte( 5, lock )
	Packet.send()
	return 0