import palanthir

CIRCLE_NUMBERS_STARTAT = 0x8b1
SPELLBOOK_GUMP = 0x8ac
SPELLBOOK_EDGEBACK_GUMP = 0x8bb
SPELLBOOK_EDGEFORWARD_GUMP = 0x8bc
SPELLBOOK_LINE_GUMP = 0x835

SMALLICONS_STARTAT = 0x8c0
LARGEICONS_STARTAT = 0x1b58

REAG_BLACKPEARL = 0
REAG_GARLIC = 1
REAG_SULFUROUSASH = 2
REAG_NIGHTSHADE = 3
REAG_SPIDERSILK = 4
REAG_BLOODMOSS = 5
REAG_GINSENG = 6
REAG_MANDRAKEROOT = 7

ReagNames = [ "Black Pearl", "Garlic", "Sulfurous Ash", "Nightshade", "Spiders' Silk", "Bloodmoss", "Ginseng", "Mandrake Root" ]

CircleNames = [ "First Circle", "Second Circle", "Third Circle", "Fourth Circle", "Fifth Circle", "Sixth Circle", "Seventh Circle", "Eigth Circle" ]

spelldefs = { '1' : [ 'Clumsy', [REAG_BLOODMOSS, REAG_NIGHTSHADE] ],
	   '2' : [ 'Create Food', [REAG_GARLIC, REAG_GINSENG, REAG_MANDRAKEROOT] ],
	   '3' : [ 'Feeblemind', [REAG_GINSENG, REAG_NIGHTSHADE] ],
	   '4' : [ 'Heal', [REAG_GARLIC, REAG_GINSENG, REAG_SPIDERSILK] ],
	   '5' : [ 'Magic Arrow', [REAG_BLACKPEARL, REAG_NIGHTSHADE] ],
	   '6' : [ 'Night sight', [REAG_SPIDERSILK, REAG_SULFUROUSASH] ],	   
	   '7' : [ 'Reactive Armor', [REAG_GARLIC, REAG_SULFUROUSASH, REAG_SPIDERSILK] ],
	   '8' : [ 'Weaken', [REAG_GARLIC, REAG_NIGHTSHADE] ],
	   
	   '9' : [ 'Agility', [REAG_BLOODMOSS, REAG_MANDRAKEROOT] ],
	   '10' : [ 'Cunning', [REAG_MANDRAKEROOT, REAG_NIGHTSHADE] ],
	   '11' : [ 'Cure', [REAG_GARLIC, REAG_GINSENG] ],
	   '12' : [ 'Harm', [REAG_NIGHTSHADE, REAG_SPIDERSILK] ],
	   '13' : [ 'Magic Trap', [REAG_GARLIC, REAG_SULFUROUSASH, REAG_SPIDERSILK] ],
	   '14' : [ 'Magic Untrap', [REAG_BLOODMOSS, REAG_SULFUROUSASH] ],
	   '15' : [ 'Protection', [REAG_GARLIC, REAG_GINSENG, REAG_SULFUROUSASH] ],
	   '16' : [ 'Strength', [REAG_MANDRAKEROOT, REAG_NIGHTSHADE] ],
	   
	   '17' : [ 'Bless', [REAG_GARLIC, REAG_MANDRAKEROOT] ],	   
	   '18' : [ 'Fireball', [REAG_BLACKPEARL] ],
	   '19' : [ 'Magic Lock', [REAG_SULFUROUSASH, REAG_BLOODMOSS, REAG_GARLIC] ],
	   '20' : [ 'Poison', [REAG_NIGHTSHADE] ],
	   '21' : [ 'Telekinesis', [REAG_BLOODMOSS, REAG_MANDRAKEROOT] ],
	   '22' : [ 'Teleport', [REAG_BLOODMOSS, REAG_MANDRAKEROOT] ],
	   '23' : [ 'Unlock', [REAG_BLOODMOSS, REAG_SULFUROUSASH] ],
	   '24' : [ 'Wall of Stone', [REAG_BLOODMOSS, REAG_GARLIC] ],
	   
	   '25' : [ 'Arch Cure', [REAG_GARLIC, REAG_GINSENG, REAG_MANDRAKEROOT] ],
	   '26' : [ 'Arch Protection', [REAG_GARLIC, REAG_GINSENG, REAG_MANDRAKEROOT, REAG_SULFUROUSASH] ],
	   '27' : [ 'Curse', [REAG_GARLIC, REAG_NIGHTSHADE, REAG_SULFUROUSASH] ],
	   '28' : [ 'Fire Field', [REAG_BLACKPEARL, REAG_SPIDERSILK, REAG_SULFUROUSASH] ],
	   '29' : [ 'Greater Heal', [REAG_GARLIC, REAG_GINSENG, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ],
	   '30' : [ 'Lightning', [REAG_MANDRAKEROOT, REAG_SULFUROUSASH] ],
	   '31' : [ 'Mana Drain', [REAG_BLACKPEARL, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ],
	   '32' : [ 'Recall', [REAG_BLACKPEARL, REAG_BLOODMOSS, REAG_MANDRAKEROOT] ],
	   
	   '33' : [ 'Blade Spirits', [REAG_BLACKPEARL, REAG_MANDRAKEROOT, REAG_NIGHTSHADE] ],
	   '34' : [ 'Dispel Field', [REAG_GARLIC, REAG_BLACKPEARL, REAG_SPIDERSILK, REAG_SULFUROUSASH] ],
	   '35' : [ 'Incognito', [REAG_BLOODMOSS, REAG_GARLIC, REAG_NIGHTSHADE] ],
	   '36' : [ 'Magic Reflection', [REAG_GARLIC, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ],
	   '37' : [ 'Mind Blast', [REAG_BLACKPEARL, REAG_MANDRAKEROOT, REAG_NIGHTSHADE, REAG_SULFUROUSASH] ],
	   '38' : [ 'Paralyze', [REAG_GARLIC, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ],
	   '39' : [ 'Poison Field', [REAG_BLACKPEARL, REAG_NIGHTSHADE, REAG_SPIDERSILK] ],
	   '40' : [ 'Summon Creature', [REAG_BLOODMOSS, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ],
	   
	   '41' : [ 'Dispel', [REAG_GARLIC, REAG_MANDRAKEROOT, REAG_SULFUROUSASH] ],
	   '42' : [ 'Energy Bolt', [REAG_BLACKPEARL, REAG_NIGHTSHADE] ],
	   '43' : [ 'Explosion', [REAG_BLOODMOSS, REAG_MANDRAKEROOT] ],
	   '44' : [ 'Invisibility', [REAG_BLOODMOSS, REAG_NIGHTSHADE] ],
	   '45' : [ 'Mark', [REAG_BLACKPEARL, REAG_BLOODMOSS, REAG_MANDRAKEROOT] ],
	   '46' : [ 'Mass Curse', [REAG_GARLIC, REAG_MANDRAKEROOT, REAG_NIGHTSHADE, REAG_SULFUROUSASH] ],
	   '47' : [ 'Paralyze Field', [REAG_BLACKPEARL, REAG_GINSENG, REAG_SPIDERSILK] ],
	   '48' : [ 'Reveal', [REAG_BLOODMOSS, REAG_SULFUROUSASH] ],
	   
	   '49' : [ 'Chain Lightning', [REAG_BLACKPEARL, REAG_MANDRAKEROOT, REAG_BLOODMOSS, REAG_SULFUROUSASH] ],
	   '50' : [ 'Energy Field', [REAG_BLACKPEARL, REAG_MANDRAKEROOT, REAG_SPIDERSILK, REAG_SULFUROUSASH] ],
	   '51' : [ 'Flame Strike', [REAG_SPIDERSILK, REAG_SULFUROUSASH] ],
	   '52' : [ 'Gate Travel', [REAG_BLACKPEARL, REAG_MANDRAKEROOT, REAG_SULFUROUSASH] ],
	   '53' : [ 'Mana Vampire', [REAG_BLACKPEARL, REAG_BLOODMOSS, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ],
	   '54' : [ 'Mass Dispel', [REAG_BLACKPEARL, REAG_GARLIC, REAG_MANDRAKEROOT, REAG_SULFUROUSASH] ],
	   '55' : [ 'Meteor Swarm', [REAG_BLOODMOSS, REAG_SPIDERSILK, REAG_MANDRAKEROOT, REAG_SULFUROUSASH] ],
	   '56' : [ 'Polymorph', [REAG_BLOODMOSS, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ],
	   
	   '57' : [ 'Earthquake', [REAG_BLOODMOSS, REAG_GINSENG, REAG_MANDRAKEROOT, REAG_SULFUROUSASH] ],
	   '58' : [ 'Energy Vortex', [REAG_BLACKPEARL, REAG_BLOODMOSS, REAG_MANDRAKEROOT, REAG_NIGHTSHADE] ],
	   '59' : [ 'Resurrection', [REAG_BLOODMOSS, REAG_GARLIC, REAG_GINSENG] ],
	   '60' : [ 'Air Elemental', [REAG_BLOODMOSS, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ],
	   '61' : [ 'Summon Deamon', [REAG_BLOODMOSS, REAG_MANDRAKEROOT, REAG_SPIDERSILK, REAG_SULFUROUSASH] ],
	   '62' : [ 'Earth Elemental', [REAG_BLOODMOSS, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ],
	   '63' : [ 'Fire Elemental', [REAG_BLOODMOSS, REAG_MANDRAKEROOT, REAG_SPIDERSILK, REAG_SULFUROUSASH] ],
	   '64' : [ 'Water Elemental', [REAG_BLOODMOSS, REAG_MANDRAKEROOT, REAG_SPIDERSILK] ]
	 }

def onLoad():
	palanthir.registerpackethandler( 0x24, onPacket )
	return 0

def onPacket( Packet ):
	if Packet.getword( 5 ) == 0xffff:
		OpenSpellbook( Packet )
		return 1
	return 0
	
def OpenSpellbook( Packet ):	
	serial = Packet.getlongword( 1 )
	
	for i in range( 0, palanthir.getgumpcount() ):
		Gump = palanthir.getgump( i )
		if Gump and Gump.cv.has_key( "name" ) and Gump.cv[ "name" ] == "spellbook" and Gump.cv[ "serial" ] == serial:						
			return 0
	
	Gump = palanthir.newgump()
	Gump.addimage( 0, 0, SPELLBOOK_GUMP, 0, 0 ) 
	Gump.activepage = 1
	Gump.cv[ "serial" ] = serial
	Gump.cv[ "name" ] = "spellbook"
	Gump.cv[ "spells" ] = {}
	Gump.cv[ "maxpage" ] = 4
	Gump.onbeforedrawgump = onBeforeDrawGump
	Gump.onbuttonclick = onButtonClick
	Gump.ondblclick = onDblClick
	Gump.onmovegump = onMoveGump
	
	for i in range( 0, 4 ):
		Gump.addpagebutton( 58 + i*35, 175, CIRCLE_NUMBERS_STARTAT + i, CIRCLE_NUMBERS_STARTAT + i, i/2+1, 0 )
	for i in range( 4, 8 ):		
		Gump.addpagebutton( 58 + 27 + i*35, 175, CIRCLE_NUMBERS_STARTAT + i, CIRCLE_NUMBERS_STARTAT + i, i/2+1, 0 )
		
	for i in range( 0, 8 ):
		if i % 2 == 0:
			Gump.addtext( 100, 16, "INDEX", 0, 2, i/2+1, 0 )
		else:
			Gump.addtext( 266, 16, "INDEX", 0, 2, i/2+1, 0 )
	
	Gump.addtext( 55, 36, "First Circle", 0, 2, 1, 0 )
	Gump.addtext( 222, 36, "Second Circle", 0, 2, 1, 0 )
	Gump.addtext( 55, 36, "Third Circle", 0, 2, 2, 0 )
	Gump.addtext( 222, 36, "Fourth Circle", 0, 2, 2, 0 )
	Gump.addtext( 55, 36, "Fifth Circle", 0, 2, 3, 0 )
	Gump.addtext( 222, 36, "Sixth Circle", 0, 2, 3, 0 )
	Gump.addtext( 55, 36, "Seventh Circle", 0, 2, 4, 0 )
	Gump.addtext( 222, 36, "Eighth Circle", 0, 2, 4, 0 )
	
	Gump.cv[ "BackButton" ] = Gump.addbutton( 50, 8, SPELLBOOK_EDGEBACK_GUMP, SPELLBOOK_EDGEBACK_GUMP, 1000, 1000 )
	Gump.cv[ "ForwardButton" ] = Gump.addbutton( 322, 8, SPELLBOOK_EDGEFORWARD_GUMP, SPELLBOOK_EDGEFORWARD_GUMP, 1001, 1000 )
	
	Gump.show()
	return 0
	
def onBeforeDrawGump( Gump ):
	serial = Gump.cv[ "serial" ]	
	book = palanthir.world.getitem( serial )
	
	if not book:
		Gump.delete()
		return 0
		
	if Gump.activepage > 1:
		Gump.cv[ "BackButton" ].page = Gump.activepage
	else:
		Gump.cv[ "BackButton" ].page = 1000
		
	if Gump.activepage < Gump.cv[ "maxpage" ]:
		Gump.cv[ "ForwardButton" ].page = Gump.activepage
	else:
		Gump.cv[ "ForwardButton" ].page = 1000
		
	Changed = 0	
	
	oldspells = {}
	for key in Gump.cv[ "spells" ].keys():
		oldspells[ key ] = Gump.cv[ "spells" ][ key ]
		
	for item in book.content:
		spellid = item.amount
		
		if spellid > 64:
			continue
		
		if oldspells.has_key( str( spellid ) ):
			del oldspells[ str( spellid ) ]
		else:
			Changed = 1
			
			circle = ((spellid-1) / 8)+1
			Spell = {}
			if circle % 2 != 0:
				Spelllink = Gump.addtextbutton( 55, 52, 0, spelldefs[ str( spellid ) ][ 0 ], 0, (circle-1)/2+1, 135, 0x223, 0x481, 0x481, 0, 0, 0, 0, 0, 0, 20, 1, 1, 0 )
				Spell[ "Link" ] = Spelllink
			else:
				Spelllink = Gump.addtextbutton( 222, 52, 0, spelldefs[ str( spellid ) ][ 0 ], 0, (circle-1)/2+1, 135, 0x223, 0x481, 0x481, 0, 0, 0, 0, 0, 0, 20, 1, 1, 0 )				
				Spell[ "Link" ] = Spelllink
				
			SpellIcon = Gump.addimage( 55, 40, SMALLICONS_STARTAT + spellid -1, 0, 5 )
			SpellIcon.cv[ "spellid" ] = spellid
			Spell[ "Icon" ] = SpellIcon
			
			CircleName = Gump.addtext( 87, 16, CircleNames[ circle-1 ], 0, 2, 5, 0 )			
			Spell[ "CircleName" ] = CircleName
			
			SpellName = Gump.addcroppedtext( 110, 40, 90, 50, spelldefs[ str( spellid ) ][ 0 ], 0, 2, 5, 2, 0, -4 )
			Spell[ "SpellName" ] = SpellName
			
			Line = Gump.addtiledimage( 56, 90, 129, 6, SPELLBOOK_LINE_GUMP, 0, 5 )
			Spell[ "Line" ] = Line
			
			Reagents = Gump.addtext( 56, 95, "Reagents:", 0, 2, 5, 0 )
			Spell[ "Reagents" ] = Reagents
			
			Reaglist = []
			for Reag in spelldefs[ str( spellid ) ][ 1 ]:
				Reaglist += [ ReagNames[ Reag ] ]
				
			ReagentNames = Gump.addcroppedtext( 56, 110, 120, 63, chr( 10 ).join( Reaglist ), 0, 0x223, 5, 5, 0, -4 )
			Spell[ "ReagentNames" ] = ReagentNames
			
			Gump.cv[ "spells" ][ str( spellid ) ] = Spell
			
	for key in oldspells.keys():	
		Changed = 1
		
	if Changed:	
		UpdateSpellbook( Gump )
	return 0
	
def UpdateSpellbook( Gump ):	
	Spells = Gump.cv[ "spells" ]
	Gump.cv[ "maxpage" ] = 4 + len( Spells.keys() ) / 2
	Count = 0
	for circle in range( 0, 8 ):
		y = 52
		for spell in range( 1, 9 ):
			spellid = circle*8 + spell
			if Spells.has_key( str( spellid ) ):
				#Textlink in Overview
				Spells[ str( spellid ) ][ "Link" ].y = y
				Spells[ str( spellid ) ][ "Link" ].pageid = 5 + Count/2
				y += 14
				
				#Spellicon
				Spells[ str( spellid ) ][ "Icon" ].page = 5 + Count/2
				if Count % 2 == 0:
					Spells[ str( spellid ) ][ "Icon" ].x = 56
				else:
					Spells[ str( spellid ) ][ "Icon" ].x = 222
				
				#Circle Name
				Spells[ str( spellid ) ][ "CircleName" ].page = 5 + Count/2
				if Count % 2 == 0:
					Spells[ str( spellid ) ][ "CircleName" ].x = 84
				else:
					Spells[ str( spellid ) ][ "CircleName" ].x = 230				
				
				#SpellName
				Spells[ str( spellid ) ][ "SpellName" ].page = 5 + Count/2
				if Count % 2 == 0:
					Spells[ str( spellid ) ][ "SpellName" ].x = 105
				else:
					Spells[ str( spellid ) ][ "SpellName" ].x = 272
					
				#Line
				Spells[ str( spellid ) ][ "Line" ].page = 5 + Count/2
				if Count % 2 == 0:
					Spells[ str( spellid ) ][ "Line" ].x = 56
				else:
					Spells[ str( spellid ) ][ "Line" ].x = 222
					
				#Reagents
				Spells[ str( spellid ) ][ "Reagents" ].page = 5 + Count/2
				if Count % 2 == 0:
					Spells[ str( spellid ) ][ "Reagents" ].x = 56
				else:
					Spells[ str( spellid ) ][ "Reagents" ].x = 222
					
				#ReagentNames
				Spells[ str( spellid ) ][ "ReagentNames" ].page = 5 + Count/2
				if Count % 2 == 0:
					Spells[ str( spellid ) ][ "ReagentNames" ].x = 56
				else:
					Spells[ str( spellid ) ][ "ReagentNames" ].x = 222	
					
				Count += 1
	return 0
	
def onButtonClick( Gump, Returnnumber ):
	if Returnnumber == 1000:
		Gump.activepage -= 1
		return 1
	elif Returnnumber == 1001:
		Gump.activepage += 1
		return 1
	
	return 0
	
def onDblClick( Gump, GumpObject ):
	if GumpObject.isimage and GumpObject.cv.has_key( "spellid" ):
		CastSpell( GumpObject.cv[ "spellid" ] )
		return 1
	return 0

def onMoveGump( Gump, GumpObject ):
	if GumpObject.isimage and GumpObject.cv.has_key( "spellid" ):
		spellid = GumpObject.cv[ "spellid" ]
		DeleteSpellIcon( spellid )
		AddSpellIcon( spellid )
		return 1
	return 0
	
def CastSpell( spellid ):
	if spellid < 10:
		CastRequest = palanthir.newpacket( 0x12, 6 )
		CastRequest.setword( 1, 6 )
		CastRequest.setbyte( 3, 0x56 )
		CastRequest.setasciistring( 4, str( spellid ), 2 )
		palanthir.sendpacket( CastRequest )
	else:
		CastRequest = palanthir.newpacket( 0x12, 7 )
		CastRequest.setword( 1, 7 )
		CastRequest.setbyte( 3, 0x56 )
		CastRequest.setasciistring( 4, str( spellid ), 3 )
		palanthir.sendpacket( CastRequest )
	return 0

def DeleteSpellIcon( spellid ):
	if palanthir.getcv()[ "spellicons" ].has_key( str( spellid ) ):
		palanthir.getcv()[ "spellicons" ][ str( spellid ) ].delete()
		del palanthir.getcv()[ "spellicons" ][ str( spellid ) ]
	return 0

def AddSpellIcon( spellid ):
	Icon = palanthir.newgump( palanthir.mouse().x-10, palanthir.mouse().y-10 )
	Image = Icon.addimage( 0, 0, SMALLICONS_STARTAT + spellid -1, 0, 0 )
	Icon.cv[ "spellid" ] = spellid
	Icon.ondelete = onIconDelete
	Icon.ondblclick = onIconDblClick
	Icon.show()
	palanthir.mouse().selecteddownlgumpobject = Image
	palanthir.mouse().selectedgumpobject = Image
	palanthir.getcv()[ "spellicons" ][ str( spellid ) ] = Icon
	return 0

def onIconDelete( Gump ):
	del palanthir.getcv()[ "spellicons" ][ str( Gump.cv[ "spellid" ] ) ]
	return 0

def onIconDblClick( Gump, GumpObject ):
	CastSpell( Gump.cv[ "spellid" ] )
	return 1

def onGameEnter():
	spellicons = {}
	for spellid in range( 1, 65 ):
		if palanthir.charconfig().getbool( "spell_" + str( spellid ) ):
			Icon = palanthir.newgump( palanthir.charconfig().getinteger( "spellx_" + str( spellid ) ), palanthir.charconfig().getinteger( "spelly_" + str( spellid ) ) )
			Image = Icon.addimage( 0, 0, SMALLICONS_STARTAT + spellid -1, 0, 0 )
			Icon.cv[ "spellid" ] = spellid
			Icon.ondelete = onIconDelete
			Icon.ondblclick = onIconDblClick
			Icon.show()
			spellicons[ str( spellid ) ] = Icon
	
	palanthir.getcv()[ "spellicons" ] = spellicons
	return 0

def onGameLeave():
	for spellid in range( 1, 65 ):
		if palanthir.getcv().has_key( "spellicons" ):
			if palanthir.getcv()[ "spellicons" ].has_key( str( spellid ) ):
				Icon = palanthir.getcv()[ "spellicons" ][ str( spellid ) ]
				palanthir.charconfig().setbool( "spell_" + str( spellid ), 1 )
				palanthir.charconfig().setinteger( "spellx_" + str( spellid ), Icon.x )
				palanthir.charconfig().setinteger( "spelly_" + str( spellid ), Icon.y )
			else:
				palanthir.charconfig().setbool( "spell_" + str( spellid ), 0 )
	return 0