/*
 * Created by PQ/SENE.
 * Copyright 4.5.2007 PQ/SENE
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef UOPDEF_H_INCLUDED
#define UOPDEF_H_INCLUDED


#if defined _WIN32 && (!__MINGW32__)
#define __PACKED
#else
#define __PACKED __attribute__ ((packed))
#endif

#ifdef WIN32
#pragma pack(push, 1)
#endif

struct uop_data_header
{
    unsigned int storedSize;    // 4
    unsigned int originalSize;  // 8
    char unk[12];               // 20
    unsigned short unk2;        // 22  (0x0001)
    unsigned int unk3;          // 26
    unsigned int unk4;          // 30
    unsigned int headerEnd;     // 34 (0x0000000c)
} __PACKED;


struct uop_block_header
{
    unsigned int blockIndex;    //4 (max files each block 100/100)
    unsigned long long nextBlockOffset;  // 12
    unsigned long long dataBlockOffset;  // 20 (0x0008 0x0003)
    unsigned int headerEnd;     // 24 (0x0000000c)
};  // not need to pack this


#endif // UOPDEF_H_INCLUDED
