/*
 * Created by PQ/SENE.
 * Copyright 4.5.2007 PQ/SENE
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <iostream>
#include <sstream>
#include "UOPReader.h"
#include "zlib.h"

using namespace std;

#define ERROR_CANTOPENFILE  -1
#define ERROR_CANTPROCESS   -2
#define ERROR_OUTOFMEM      -3
#define ERROR_UNCOMPRESS_MISMATCH -4

unsigned short  myendian2 (unsigned short a) {
unsigned short res = 0; for (int i=0;i<2;++i) res += ((unsigned char*)&a)[i] * (1<<(8*i)); return res;
}
unsigned int  myendian4 (unsigned int a) {
unsigned int res = 0; for (int i=0;i<4;++i) res += ((unsigned char*)&a)[i] * (1<<(8*i)); return res;
}
unsigned long long  myendian8 (unsigned long long a) {
unsigned long long res = 0; for (int i=0;i<8;++i) res += ((unsigned char*)&a)[i] * (1<<(8*i));  return res;
}

CUOPReader::CUOPReader( const char* lpszPath )
{
    _fd = fopen( lpszPath, "rb" );
    if (! _fd )
        throw ERROR_CANTOPENFILE;

    process();
}

CUOPReader::~CUOPReader()
{
    if ( _fd )
        fclose( _fd );

    for ( BlockList::iterator it = _blocks.begin();
        it != _blocks.end(); ++it )
        delete *it;
}

void CUOPReader::process()
{
    fseek( _fd, 24, SEEK_SET ); // 0x18
    fread( &_numOfChunks , 4, 1, _fd );
    _numOfChunks=myendian4(_numOfChunks);
    printf( "Found %d of files/chunks\n", _numOfChunks );
    fseek( _fd, 12, SEEK_CUR );

    CUOPBlock* pBlock = 0;
    int chunksLeft = _numOfChunks;
    do
    {
        int chunkCount = chunksLeft > 100?100:chunksLeft;
        pBlock = new CUOPBlock( _fd, chunkCount );
        chunksLeft-=chunkCount;

        _blocks.push_back( pBlock );
        if ( pBlock->IsLastBlock() )
        {
            pBlock = 0;
            printf( "letzter block" );
        }
        else
        {
            fseek( _fd, pBlock->GetHeader()->nextBlockOffset, SEEK_SET );
            printf( "nicht letzter block" );
        }
    } while ( pBlock );
}

void CUOPBlock::process()
{
    _header = (uop_block_header*)malloc(sizeof(uop_block_header));
    if (!_header )
        throw ERROR_OUTOFMEM;

    fread( _header, sizeof(uop_block_header), 1, _fd );

    _header->blockIndex=myendian4(_header->blockIndex);
    _header->nextBlockOffset=myendian8(_header->nextBlockOffset);
    _header->dataBlockOffset=myendian8(_header->dataBlockOffset);
    _header->headerEnd=myendian4(_header->headerEnd);

    printf( "Block Index %d\n"
        "next block: 0x%016lX\n"
        "data block: 0x%016lX\n"
        "header end: %08x\n",
        (int)_header->blockIndex,
        (int)_header->nextBlockOffset,
        (int)_header->dataBlockOffset,
        (int)_header->headerEnd);

    _dataHeader = (uop_data_header*) malloc( sizeof(uop_data_header)*_numOfChunks );
    printf("longlong=%d\n",sizeof(long long));
    printf("uop_block_header=%d\n",sizeof(uop_block_header));
    printf("uop_data_header=%d\n",sizeof(uop_data_header));
    if ( !_dataHeader )
        throw ERROR_OUTOFMEM;

    for ( int i = 0; i < _numOfChunks; ++i )
    {
        fread( &_dataHeader[i], 34, 1, _fd );

        _dataHeader[i].storedSize   =myendian4(_dataHeader[i].storedSize);
        _dataHeader[i].originalSize =myendian4(_dataHeader[i].originalSize);
        _dataHeader[i].unk3         =myendian4(_dataHeader[i].unk3);
        _dataHeader[i].unk4         =myendian4(_dataHeader[i].unk4);
        _dataHeader[i].headerEnd    =myendian4(_dataHeader[i].headerEnd);

        printf( "header %d/%d:\n"
            "\tsize: %d/%d (compressed/original)\n"
            "\tUnknown 2: %d \n"
            "\tUnknown 3: %d \n"
            "\tUnknown 4: %d \n"
            "\tHeader End: %d \n",
            i+1,  (int)_numOfChunks,  (int)_dataHeader[i].storedSize,  (int)_dataHeader[i].originalSize,
             (int)_dataHeader[i].unk2,  (int)_dataHeader[i].unk3,  (int)_dataHeader[i].unk4,
             (int)_dataHeader[i].headerEnd );
    }

    fseek( _fd, _header->dataBlockOffset, SEEK_SET );

    // skipped 12 bytes
    _rawChunkData = (unsigned char**)malloc(sizeof(unsigned char*)*_numOfChunks);
    if ( !_rawChunkData )
        throw ERROR_OUTOFMEM;

    for ( int i = 0; i < _numOfChunks; ++i )
    {
        fseek( _fd, 12, SEEK_CUR );
        _rawChunkData[i] = (unsigned char*)malloc(sizeof(unsigned char) * _dataHeader[i].storedSize);
        fread( _rawChunkData[i], sizeof(unsigned char), _dataHeader[i].storedSize, _fd );
    }
}

void CUOPBlock::WriteChunk( const char* lpszPath, int idx )
{
    unsigned long destLen = _dataHeader[idx].originalSize;
    unsigned char* decomp = (unsigned char*)malloc( sizeof(unsigned char)*destLen);

    if (_dataHeader[idx].originalSize!=_dataHeader[idx].storedSize)
        uncompress( decomp, &destLen, _rawChunkData[idx], _dataHeader[idx].storedSize );
    else
        decomp=_rawChunkData[idx];

    FILE* fd_out = fopen( lpszPath, "wb" );
    if ( !fd_out )
        throw ERROR_CANTOPENFILE;
    //if ( _dataHeader[idx].storedSize != destLen )
        //throw ERROR_UNCOMPRESS_MISMATCH;

    fwrite( decomp, sizeof(unsigned char), destLen, fd_out );
    fclose( fd_out );
    free( decomp );
}

void CUOPBlock::WriteAllChunks( const char* lpszFileName )
{
    char fileName[100];
    for ( int i = 0; i < _numOfChunks; ++i )
    {
        sprintf( fileName, "%s_%d.raw", lpszFileName, i );
        WriteChunk( (char*)fileName, i );
    }
}

void CUOPReader::WriteAllBlocks( const char* lpszName ) const
{
    char fileName[100];
    for ( unsigned int i = 0; i < _blocks.size() ; ++i )
    {
        sprintf( fileName, "%s_b%d", lpszName, i );
        _blocks[i]->WriteAllChunks( fileName );
    }
}
