/*
 * Created by PQ/SENE.
 * Copyright 4.5.2007 PQ/SENE
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef UOPREADER_H_INCLUDED
#define UOPREADER_H_INCLUDED

#include "UOPDef.h"
#include "stdio.h"
#include <vector>

using namespace std;

class CUOPBlock
{
    public:
    CUOPBlock( FILE* istream, int numOfChunks )
        : _fd(istream), _numOfChunks(numOfChunks),
        _header(0), _dataHeader(0), _rawChunkData(0)
    {
        process();
    }
    ~CUOPBlock()
    {
        free( _header );
        free( _dataHeader );
        if ( _rawChunkData )
        {
            for ( int i = 0; i < _numOfChunks; ++i )
                free( _rawChunkData[i] );
            free( _rawChunkData );
        }
    }
    uop_block_header* GetHeader() const { return _header; }
    uop_data_header* GetDataHeader() const { return _dataHeader; }
    bool IsLastBlock() const { return _header->nextBlockOffset == 0; }
    unsigned char* GetRawChunkStream(int idx) { return _rawChunkData[idx]; }
    void WriteChunk( const char* lpszPath, int idx );
    void WriteAllChunks( const char* lpszFileName );

    private:
    void process();

    FILE* _fd;
    int _numOfChunks;
    uop_block_header* _header;
    uop_data_header* _dataHeader;
    unsigned char** _rawChunkData;
};

typedef vector<CUOPBlock*> BlockList;

class CUOPReader
{
    public:
    CUOPReader( const char* lpszFileName );
    ~CUOPReader();
    int GetNumberOfBlocks() const { return _blocks.size(); }
    int GetNumberOfChunks() const { return _numOfChunks; }
    CUOPBlock* GetBlock(int idx) const { return _blocks[idx]; }
    void WriteAllBlocks(const char* lpszFileName) const;

    private:
    void process();

    FILE* _fd;
    int _numOfChunks;   //total number
    BlockList _blocks;
};


#endif // UOPREADER_H_INCLUDED
