/*
 * Created by PQ/SENE.
 * Copyright 4.5.2007 PQ/SENE
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <iostream>
#include "zlib.h"
#include "UOPReader.h"

using namespace std;


int main(int argc, char* argv[])
{
    string filename;
    string outname = "unpacked";

    if ( argc > 1 )
        filename = argv[1];
    if ( argc > 2 )
        outname = argv[2];

    if ( filename.empty() )
    {
        printf("UOP v0.2 (Ultima Online : Kingdom Reborn *.uop Fileunpacker)\n");
        printf("Copyright 4.5.2007 PQ/SENE\n");
        printf("\n");
        printf("No file specified.\n");
        printf("usage:\n");
        printf("uop.exe filename.uop [outputname]\n");
    }
    else
    {
        CUOPReader r( filename.c_str() );
        r.WriteAllBlocks( outname.c_str() );
    }
	return 0;
}
